/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class JsonUtil {
    private static Gson GSON_INSTANCE = new GsonBuilder().serializeNulls().create();
    private static Gson GSON_INSTANCE_IGNORE_NULL = new GsonBuilder().create();

    public static String toString(Object src) {
        return GSON_INSTANCE.toJson(src);
    }

    public static String toStringIgnoreNull(Object src) {
        return GSON_INSTANCE_IGNORE_NULL.toJson(src);
    }

    public static JsonElement toJsonTreeIgnoreNull(Object src) {
        return GSON_INSTANCE_IGNORE_NULL.toJsonTree(src);
    }

    public static Map<String, Object> fromJsonMap(String src) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)GSON_INSTANCE.fromJson(src, type);
    }

    public static boolean isNull(JsonElement pElement) {
        return null == pElement || pElement.isJsonNull();
    }

    public static boolean isNullOrEmpty(JsonElement pElement) {
        return null == pElement || pElement.isJsonNull() || "".equals(pElement.getAsString());
    }

    public static boolean isNullOrEmptyOrSpace(JsonElement pElement) {
        return null == pElement || pElement.isJsonNull() || "".equals(pElement.getAsString().trim());
    }
}

