/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.digiwin.app.container.exceptions.DWTokenSignatureException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import com.digiwin.utils.DWTenantUtils;
import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWInnerInvocationUtils {
    private static Log log = LogFactory.getLog(DWInnerInvocationUtils.class);
    public static String HEADER_KEY_INNER_TOKEN = "innerToken";
    private static Gson gson = DWGsonProvider.getGson();
    private static String thisDapUrl;
    private static String[] groupNameAlias;

    public static void setThisDapUrl(String thisDapUrl) {
        DWInnerInvocationUtils.thisDapUrl = thisDapUrl;
    }

    public static void setGroupNameAlias(String[] groupNameAlias) {
        log.info((Object)("dap.module.name.alias:" + Arrays.toString(groupNameAlias)));
        DWInnerInvocationUtils.groupNameAlias = groupNameAlias;
    }

    public static String getGroupNameByAlias(String name) {
        if (groupNameAlias == null || groupNameAlias.length == 0 || name == null) {
            return name;
        }
        for (String groupStr : groupNameAlias) {
            String[] groups = groupStr.split(":");
            String alias = groups[1].trim();
            if (!alias.equals(name)) continue;
            return groups[0].trim();
        }
        return name;
    }

    public static String getGroupAlias(String name) {
        if (groupNameAlias == null || groupNameAlias.length == 0 || name == null) {
            return name;
        }
        for (String groupStr : groupNameAlias) {
            String[] groups = groupStr.split(":");
            String group = groups[0].trim();
            if (!group.equals(name)) continue;
            return groups[1].trim();
        }
        return name;
    }

    public static String getInnerToken() {
        Map profile = DWServiceContext.getContext().getProfile();
        return DWInnerInvocationUtils.getInnerToken(profile);
    }

    public static String getInnerToken(Map<String, Object> profile) {
        if (profile == null) {
            profile = new HashMap<String, Object>();
        }
        ArrayList<String> longValueKeyList = new ArrayList<String>();
        HashMap<String, Object> clonedProfile = new HashMap<String, Object>(profile);
        for (Map.Entry item : clonedProfile.entrySet()) {
            Object value = item.getValue();
            if (!(value instanceof Long)) continue;
            longValueKeyList.add((String)item.getKey());
            clonedProfile.put((String)item.getKey(), value.toString());
        }
        clonedProfile.put("@@longValueKeyList", longValueKeyList);
        String jsonString = gson.toJson(clonedProfile);
        String innertToken = JWT.create().withClaim("profile", jsonString).sign(Algorithm.none());
        return innertToken;
    }

    public static boolean isInnerInvocation(HttpServletRequest request) {
        String innerToken = request.getHeader(HEADER_KEY_INNER_TOKEN);
        return innerToken != null && !innerToken.isEmpty();
    }

    public static Map<String, Object> parseInnerInvocationProfile(HttpServletRequest request) throws DWTokenSignatureException {
        try {
            String innerToken = request.getHeader(HEADER_KEY_INNER_TOKEN);
            DecodedJWT jwt = JWT.decode((String)innerToken);
            String profileJson = jwt.getClaim("profile").asString();
            Map profile = (Map)new Gson().fromJson(profileJson, HashMap.class);
            if (profile.containsKey("@@longValueKeyList")) {
                List longValueKeyList = (List)profile.remove("@@longValueKeyList");
                for (String key : longValueKeyList) {
                    profile.put(key, Long.parseLong((String)profile.get(key)));
                }
            }
            return profile;
        }
        catch (Exception e) {
            throw new DWTokenSignatureException(e);
        }
    }

    public static Gson getGson() {
        return gson;
    }

    public static HttpResponseModel innerInvoke(String moduleName, String serviceName, String methodName, Map<String, Object> parameters, Map<String, Object> profile) throws Exception {
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        String requestBody = gson.toJson(parameters);
        requestModel.setRequestBody(requestBody);
        HashMap<String, String> header = new HashMap<String, String>();
        String tenantId = (String)profile.get(DWTenantUtils.getIamTenantIdKey());
        String innerToken = DWInnerInvocationUtils.getInnerToken(profile);
        header.put(HEADER_KEY_INNER_TOKEN, innerToken);
        header.put("Content-Type", "application/json;charset=UTF-8");
        header.put("routerKey", tenantId);
        requestModel.setRequestHeader(header);
        moduleName = DWInnerInvocationUtils.getGroupAlias(moduleName);
        String url = String.format("%s/restful/service/%s/%s/%s", thisDapUrl, moduleName, serviceName, methodName);
        requestModel.setUrl(url);
        requestModel.setRequestMethod(DWRequestMethod.POST);
        long threadId = Thread.currentThread().getId();
        log.info((Object)String.format("[DWInnerInvocationUtils]>inner invocation request{%s}>routerKey=%s, url=%s", threadId, tenantId, url));
        HttpResponseModel responseModel = HttpRequester.submitRequest((HttpRequestModel)requestModel);
        log.info((Object)String.format("[DWInnerInvocationUtils]>inner invocation result{%s}>status=%s", threadId, responseModel.getHttpStatusCode()));
        return responseModel;
    }
}

