/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.log.utils.DWLogUtils;
import com.digiwin.app.service.DWServiceContext;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;

public class LogContextFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String traceId = httpRequest.getHeader("traceId");
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = DWLogUtils.getTraceId();
        }
        httpResponse.addHeader("traceId", StringEscapeUtils.escapeJava((String)traceId));
        DWServiceContext.getContext().setTraceId(traceId);
        HashMap<String, String> serviceLogMap = new HashMap<String, String>();
        serviceLogMap.put("traceId", traceId);
        serviceLogMap.putIfAbsent("client", httpRequest.getRemoteHost());
        serviceLogMap.putIfAbsent("server", DWLogUtils.logLocalHostIpName);
        try {
            ThreadContext.putAll(serviceLogMap);
            chain.doFilter(request, response);
        }
        finally {
            ThreadContext.removeAll(serviceLogMap.keySet());
        }
    }

    public void destroy() {
    }
}

