/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.log.utils.DWLogUtils;
import com.digiwin.app.service.DWServiceContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;

public class LogContextFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String traceId = httpRequest.getHeader("traceId");
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = DWLogUtils.getTraceId();
        }
        httpResponse.addHeader("traceId", traceId);
        DWServiceContext.getContext().setTraceId(traceId);
        HashMap<String, String> serviceLogMap = new HashMap<String, String>();
        serviceLogMap.put("traceId", traceId);
        serviceLogMap.putIfAbsent("client", httpRequest.getRemoteHost());
        serviceLogMap.putIfAbsent("server", DWLogUtils.logLocalHostIpName);
        ThreadContext.putAll(serviceLogMap);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

