/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.service.DWFile;
import com.digiwin.gateway.output.StandardExceptionOutput;
import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

public final class DWFilterUtils {
    public static <T> T failResponse(Exception exception, HttpServletResponse response) throws IOException {
        return DWFilterUtils.failResponse(exception, response, null);
    }

    public static <T> T failResponse(Exception exception, HttpServletResponse response, HttpStatus status) throws IOException {
        HttpStatus httpStatus = status == null ? HttpStatus.BAD_REQUEST : status;
        Map standardErrorResult = StandardExceptionOutput.getStandardErrorResult((HttpStatus)httpStatus, (Throwable)exception);
        String jsonFromMap = new Gson().toJson((Object)standardErrorResult);
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        response.setStatus(httpStatus.value());
        response.getOutputStream().write(jsonFromMap.getBytes());
        return null;
    }

    public static boolean isMultipartFormDataContentType(HttpServletRequest request) {
        Optional<String> contentTypeOptional = Optional.ofNullable(request.getContentType());
        String contentType = contentTypeOptional.orElse("").toLowerCase();
        return contentType.contains(MediaType.MULTIPART_FORM_DATA.toString().toLowerCase());
    }

    public static boolean isMultipartFormDataContentType(String contentType) {
        return contentType == null ? false : contentType.contains(MediaType.MULTIPART_FORM_DATA.toString().toLowerCase());
    }

    public static <T extends DWDefaultParameters> T getFormDataParameters(Class<T> parameterClazz, HttpServletRequest request, HttpServletResponse response) throws IOException {
        DWDefaultParameters parameters = null;
        try {
            parameters = (DWDefaultParameters)parameterClazz.newInstance();
            Collection parts = request.getParts();
            HashMap<String, List> fileMap = new HashMap<String, List>();
            for (Part part : parts) {
                String parameterName = part.getName();
                String fileName = part.getSubmittedFileName();
                InputStream inputStream = part.getInputStream();
                if (StringUtils.isBlank((CharSequence)fileName)) {
                    String value = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    parameters.put(parameterName, (Object)value);
                    continue;
                }
                List files = fileMap.getOrDefault(parameterName, new ArrayList());
                DWFile uploadFile = new DWFile();
                uploadFile.setFileName(fileName);
                uploadFile.setInputStream(inputStream);
                files.add(uploadFile);
                fileMap.put(parameterName, files);
            }
            for (Map.Entry entry : fileMap.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                if (value.size() == 1) {
                    parameters.put(key, value.get(0));
                    continue;
                }
                parameters.put(key, (Object)value);
            }
        }
        catch (Exception e) {
            return (T)((DWDefaultParameters)DWFilterUtils.failResponse(e, response));
        }
        return (T)parameters;
    }
}

