/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.schedule.exception.DistributedScheduleException;
import com.digiwin.gateway.fuse.exception.DWBrokenCircuitException;
import com.digiwin.gateway.fuse.exception.DWOverLimitException;
import com.digiwin.gateway.output.StandardExceptionOutput;
import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
@ConditionalOnProperty(name={"dap.bean.scan.enabled"}, havingValue="true", matchIfMissing=false)
public class ExceptionFilter {
    private boolean autoFuseHttpStatusCode = true;

    public void setAutoFuseHttpStatusCode(boolean autoFuseHttpStatusCode) {
        this.autoFuseHttpStatusCode = autoFuseHttpStatusCode;
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<String> notFound404Handler(Throwable exception) {
        return this.generateErrorResponseEntity("404", HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<String> exceptionHandler(Throwable exception) {
        HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        Throwable targetException = StandardExceptionOutput.getTargetException((Throwable)exception);
        if (targetException instanceof DWBusinessException) {
            httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        } else if (targetException instanceof DWException) {
            httpStatus = HttpStatus.BAD_REQUEST;
        }
        if (Boolean.valueOf(this.autoFuseHttpStatusCode).booleanValue()) {
            if (exception instanceof DWOverLimitException) {
                statusCode = ((DWOverLimitException)exception).getStatusCode();
                httpStatus = HttpStatus.valueOf((int)statusCode);
            } else if (exception instanceof DWBrokenCircuitException) {
                statusCode = ((DWBrokenCircuitException)exception).getStatusCode();
                httpStatus = HttpStatus.valueOf((int)statusCode);
            }
        }
        if (exception instanceof DistributedScheduleException) {
            httpStatus = HttpStatus.valueOf((int)((DistributedScheduleException)exception).getStatusCode());
        }
        Map standardErrorMessage = StandardExceptionOutput.getStandardErrorResult((HttpStatus)httpStatus, (Throwable)exception);
        Gson gson = DWGsonProvider.getGson();
        String json = gson.toJson((Object)standardErrorMessage);
        return this.generateErrorResponseEntity(json, httpStatus);
    }

    private <T> ResponseEntity<T> generateErrorResponseEntity(T message, HttpStatus httpStatus) {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        request.setAttribute("isError", (Object)true);
        return new ResponseEntity(message, (HttpStatusCode)httpStatus);
    }
}

