/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWFileParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWQueryStringParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.DWTargetInfo;
import com.digiwin.app.container.exceptions.DWHeaderNotFoundException;
import com.digiwin.app.container.exceptions.DWMethodNotFoundException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceLocationInfo;
import com.digiwin.app.service.DWSimpleServiceLocationInfo;
import com.digiwin.gateway.filter.DWFilterUtils;
import com.digiwin.gateway.filter.DWInnerInvocationUtils;
import com.digiwin.gateway.http.DWRequestWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public class DWMethodLocateFilter
implements Filter {
    @Autowired
    private DWContainerContext containerContext;

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String[] uriParts;
        DWHeader header;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        if (requestURI.startsWith(httpRequest.getContextPath())) {
            requestURI = requestURI.replaceFirst(httpRequest.getContextPath(), "");
        }
        if ((header = this.getHeaderBySimpleRule(httpRequest, httpResponse, uriParts = requestURI.split("/"))) == null) {
            return;
        }
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)httpRequest);
        DWParameters parameters = this.getParameters(httpRequest, requestWrapper, httpResponse);
        if (parameters == null) {
            return;
        }
        DWTargetInfo targetInfo = this.getMethodBySimpleRule(httpRequest, httpResponse, header, parameters, uriParts);
        DWTargetAPI api = targetInfo.getTargetApi();
        if (api == null) {
            return;
        }
        request.setAttribute("targetAPI", (Object)api);
        request.setAttribute("targetParameters", (Object)targetInfo.getParameters());
        chain.doFilter((ServletRequest)requestWrapper, response);
    }

    private DWParameters getParameters(HttpServletRequest request, DWRequestWrapper requestWrapper, HttpServletResponse response) throws IOException {
        DWFileParameters parameters;
        Optional<String> contentTypeOptional = Optional.ofNullable(request.getContentType());
        String contentType = contentTypeOptional.orElse("").toLowerCase();
        if (DWFilterUtils.isMultipartFormDataContentType(contentType)) {
            parameters = DWFilterUtils.getFormDataParameters(DWFileParameters.class, request, response);
        } else if (contentType.toLowerCase().contains("xml")) {
            String body = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
            DWServiceContext.getContext().setRequestBody(body);
            HashMap<String, String> source = new HashMap<String, String>();
            source.put("xml", body);
            parameters = new DWDefaultParameters(source);
        } else if ("get".equalsIgnoreCase(request.getMethod())) {
            parameters = new DWQueryStringParameters(request);
        } else {
            String body = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
            DWServiceContext.getContext().setRequestBody(body);
            parameters = new DWDefaultParameters(body);
        }
        return parameters;
    }

    private DWHeader getHeaderBySimpleRule(HttpServletRequest request, HttpServletResponse response, String[] uriParts) throws IOException {
        DWHeader header = null;
        String groupName = null;
        Object serviceName = null;
        if (uriParts.length == 6 && "post".equalsIgnoreCase(request.getMethod())) {
            groupName = DWInnerInvocationUtils.getGroupNameByAlias((String)uriParts[3]);
            serviceName = uriParts[4];
            header = this.containerContext.getDWHeader(groupName, (String)serviceName);
        }
        if (header == null && uriParts.length >= 5) {
            groupName = DWInnerInvocationUtils.getGroupNameByAlias((String)uriParts[3]);
            Object resource = uriParts[4];
            resource = ((String)resource).substring(0, 1).toUpperCase() + ((String)resource).substring(1);
            serviceName = "I" + (String)resource + "Service";
            header = this.containerContext.getDWHeader(groupName, (String)serviceName);
        }
        if (header == null) {
            if (groupName == null) {
                groupName = "unknown module";
            }
            if (serviceName == null) {
                serviceName = "unknown service";
            }
            DWHeaderNotFoundException exception = new DWHeaderNotFoundException(groupName, (String)serviceName);
            DWFilterUtils.failResponse((Exception)exception, response);
        }
        return header;
    }

    private DWTargetInfo getMethodBySimpleRule(HttpServletRequest request, HttpServletResponse response, DWHeader header, DWParameters parameters, String[] uriParts) throws IOException {
        DWSimpleServiceLocationInfo locationInfo;
        String httpMethod = request.getMethod().toLowerCase();
        Object methodName = null;
        DWTargetInfo targetInfo = null;
        DWTargetAPI api = null;
        DWParameters finalParameters = parameters;
        if (uriParts.length >= 5) {
            methodName = httpMethod;
            if (uriParts.length > 5) {
                String[] subResourceArray;
                for (String subResource : subResourceArray = Arrays.copyOfRange(uriParts, 5, uriParts.length)) {
                    methodName = (String)methodName + subResource.substring(0, 1).toUpperCase() + subResource.substring(1);
                }
            }
            locationInfo = new DWSimpleServiceLocationInfo(header, (String)methodName, parameters);
            api = this.containerContext.getAPI((DWServiceLocationInfo)locationInfo);
            finalParameters = locationInfo.getParameters();
        }
        if (!DWTargetAPI.isValid(api) && uriParts.length == 6 && "post".equalsIgnoreCase(httpMethod)) {
            methodName = uriParts[5];
            locationInfo = new DWSimpleServiceLocationInfo(header, (String)methodName, parameters);
            api = this.containerContext.getAPI((DWServiceLocationInfo)locationInfo);
            finalParameters = locationInfo.getParameters();
        }
        if (!DWTargetAPI.isValid(api)) {
            DWMethodNotFoundException e = new DWMethodNotFoundException(header.getModuleName(), header.getServiceName(), (String)methodName, parameters);
            DWFilterUtils.failResponse((Exception)e, response);
            api = null;
        }
        targetInfo = new DWTargetInfo(api, finalParameters);
        return targetInfo;
    }

    public void destroy() {
    }
}

