/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.gateway.output.StandardExceptionOutput;
import com.google.gson.Gson;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class ResponseSizeLimitFilter
implements Filter {
    private static Log log = LogFactory.getLog(ResponseSizeLimitFilter.class);
    public static final String RESPONSE_WARN_SIZE_KEY = "responseWarnSize";
    public static final String RESPONSE_LIMIT_SIZE_KEY = "responseLimitSize";
    public static final String RESPONSE_OVER_SIZE_ACTION_KEY = "responseOverSizeAction";
    public static final int DEFAULT_RESPONSE_WARN_SIZE = -1;
    public static final int DEFAULT_RESPONSE_LIMIT_SIZE = 30;
    public static final ResponseOverSizeAction DEFAULT_RESPONSE_OVER_SIZE_ACTION = ResponseOverSizeAction.NO_ACTION;
    private int warn = -1;
    private int limit = 30;
    private ResponseOverSizeAction responseOverSizeAction = DEFAULT_RESPONSE_OVER_SIZE_ACTION;

    public ResponseSizeLimitFilter(int warn, int limit, ResponseOverSizeAction responseOverSizeAction) {
        if (warn != -1) {
            this.warn = warn * 1024 * 1024;
        }
        this.limit = limit * 1024 * 1024;
        this.responseOverSizeAction = responseOverSizeAction;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        if (response instanceof ContentCachingResponseWrapper) {
            ContentCachingResponseWrapper contentCachingResponseWrapper = (ContentCachingResponseWrapper)response;
            int contentSize = contentCachingResponseWrapper.getContentSize();
            log.debug((Object)("[ResponseSizeLimitFilter] contentSize = " + contentSize));
            if (contentSize > this.limit) {
                if (this.warn == -1) {
                    switch (this.responseOverSizeAction.ordinal()) {
                        case 2: {
                            log.error((Object)("[ResponseSizeLimitFilter] payload too large, contentSize = " + contentSize + " ,limit = " + this.limit));
                            this.setError(contentCachingResponseWrapper, contentSize);
                            break;
                        }
                        case 1: {
                            log.warn((Object)("[ResponseSizeLimitFilter] payload too large, contentSize = " + contentSize + " ,limit = " + this.limit));
                            this.setWarning(contentCachingResponseWrapper, contentSize);
                            break;
                        }
                    }
                } else if (contentSize > this.warn) {
                    log.error((Object)("[ResponseSizeLimitFilter] payload too large, contentSize = " + contentSize + " ,limit = " + this.limit));
                    this.setError(contentCachingResponseWrapper, contentSize);
                } else {
                    log.warn((Object)("[ResponseSizeLimitFilter] payload too large, contentSize = " + contentSize + " ,limit = " + this.limit));
                    this.setWarning(contentCachingResponseWrapper, contentSize);
                }
            }
        }
    }

    public void destroy() {
    }

    private void setError(ContentCachingResponseWrapper contentCachingResponseWrapper, int contentSize) throws IOException {
        ServletException servletException = new ServletException("Payload Too Large");
        HttpStatus httpStatus = HttpStatus.PAYLOAD_TOO_LARGE;
        Map standardErrorResult = StandardExceptionOutput.getStandardErrorResult((HttpStatus)httpStatus, (Throwable)servletException);
        Gson gson = new Gson();
        String jsonFromMap = gson.toJson((Object)standardErrorResult);
        contentCachingResponseWrapper.resetBuffer();
        contentCachingResponseWrapper.addHeader("X-API-ERROR", "payload too large, contentSize = " + contentSize + " ,limit = " + this.limit);
        contentCachingResponseWrapper.addHeader("Content-Type", "application/json");
        contentCachingResponseWrapper.setStatus(httpStatus.value());
        contentCachingResponseWrapper.getOutputStream().write(jsonFromMap.getBytes());
    }

    private void setWarning(ContentCachingResponseWrapper contentCachingResponseWrapper, int contentSize) {
        contentCachingResponseWrapper.addHeader("X-API-WARNING", "payload too large, contentSize = " + contentSize + " ,limit = " + this.limit);
    }

    public static enum ResponseOverSizeAction {
        NO_ACTION("noAction"),
        WARNING("warning"),
        ERROR("error");

        private String text;

        private ResponseOverSizeAction(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static ResponseOverSizeAction fromString(String text) {
            for (ResponseOverSizeAction responseAction : ResponseOverSizeAction.values()) {
                if (!responseAction.text.equalsIgnoreCase(text)) continue;
                return responseAction;
            }
            return null;
        }
    }
}

