/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.server;

import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.digiwin.gateway.server.DWTomcatProperties;
import org.apache.catalina.connector.Connector;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;

public class DWTomcat
extends TomcatServletWebServerFactory {
    private DWTomcatProperties properties;

    public DWTomcat(DWTomcatProperties properties) {
        this.properties = properties == null ? new DWTomcatProperties() : properties;
        this.initialize();
    }

    private void initialize() {
        super.addConnectorCustomizers(new TomcatConnectorCustomizer[]{new DWTomcatConnectorCustomizer()});
    }

    private class DWTomcatConnectorCustomizer
    implements TomcatConnectorCustomizer {
        private DWTomcatConnectorCustomizer() {
        }

        public void customize(Connector connector) {
            connector.setPort(Integer.valueOf(DWTomcat.this.properties.getPort()).intValue());
            connector.setProperty("acceptCount", DWTomcat.this.properties.getAcceptCount());
            connector.setProperty("maxConnections", DWTomcat.this.properties.getMaxConnections());
            connector.setProperty("minSpareThreads", DWTomcat.this.properties.getMinSpareThreads());
            connector.setProperty("maxThreads", DWTomcat.this.properties.getMaxThreads());
            if (!StringUtils.isEmpty((String)DWTomcat.this.properties.getRelaxedPathChars())) {
                connector.setProperty("relaxedPathChars", DWTomcat.this.properties.getRelaxedPathChars());
            }
            if (!StringUtils.isEmpty((String)DWTomcat.this.properties.getRelaxedQueryChars())) {
                connector.setProperty("relaxedQueryChars", DWTomcat.this.properties.getRelaxedQueryChars());
            }
        }
    }
}

