/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.controller;

import com.digiwin.app.commons.eai.alarm.EAICallbackDelayed;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.eai.CallbackTask;
import com.digiwin.app.eai.DWEAICallback;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.eai.DigiSrvcode;
import com.digiwin.app.eai.EAIExceptionHandler;
import com.digiwin.app.eai.FasyncChainTask;
import com.digiwin.app.eai.FasyncTask;
import com.digiwin.app.eai.exception.DWEaiException;
import com.digiwin.app.eai.fasynctask.FasyncTaskService;
import com.digiwin.app.eai.serviceinstance.ServiceInstanceService;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.json.gson.DWJsonViewGsonProvider;
import com.digiwin.app.log.DapLogUtils;
import com.digiwin.app.log.dto.DapLogDto;
import com.digiwin.app.log.service.DapLogService;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWEAIChainEndResult;
import com.digiwin.app.service.DWEAIChainProgressResult;
import com.digiwin.app.service.DWEAIChainResult;
import com.digiwin.app.service.DWEAIChainTotalResult;
import com.digiwin.app.service.DWEAIErrorResult;
import com.digiwin.app.service.DWEAIFasyncChainEndResult;
import com.digiwin.app.service.DWEAIFasyncChainResult;
import com.digiwin.app.service.DWEAIFasyncResult;
import com.digiwin.app.service.DWEAIFasyncTaskResult;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceChainInfoStorage;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.alarm.EaiCallbackArarmService;
import com.digiwin.app.service.eai.DWEAIHeaderRepository;
import com.digiwin.app.service.utils.DWServiceChainUtils;
import com.digiwin.gateway.controller.EaiAsyncTaskThreadFactory;
import com.digiwin.gateway.controller.EaiInfoUtils;
import com.digiwin.gateway.http.DWRequestWrapper;
import com.digiwin.gateway.service.eai.IEAISyncProdService;
import com.digiwin.gateway.service.eai.SyncProdServiceVo;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Updates;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EaiController
implements ApplicationListener<InstanceRegisteredEvent> {
    private static Log log = LogFactory.getLog(EaiController.class);
    private static final String CHAIN_PARAMETER_PREFIX = "eai:chain:parameter:";
    private static final String CHAIN_HISTORY_PREFIX = "eai:chain:history:";
    private static final String CHAIN_SIGNAL_PREFIX = "eai:chain:signal:";
    private static final String CHAIN_PROGRESS_SYNC_PREFIX = "eai:chain:progress:sync:";
    private static final String CHAIN_PROGRESS_FASYNC_PREFIX = "eai:chain:progress:fasync:";
    private static final String CHAIN_PROGRESS_FASYNC_HEADER_PREFIX = "eai:chain:progress:fasync:header:";
    private static final String KEY_TARGET_API = "targetAPI";
    private static final String KEY_HEADERS = "headers";
    private static final String KEY_DIGI_SRVVER = "digi-srvver";
    private static final String KEY_DIGI_SRVCODE = "digi-srvcode";
    private static final List<String> SERVICE_HEADER_WHITELIST = Stream.of("token", "routerkey", "locale", "innertoken", "security-token", "digi-compressed", "tx-xid", "Pinpoint-TraceID", "Pinpoint-SpanID", "Pinpoint-pSpanID", "Pinpoint-Flags", "Pinpoint-pAppName", "Pinpoint-pAppType", "Pinpoint-Host", "pinpoint-traceid", "pinpoint-spanid", "pinpoint-pspanid", "pinpoint-flags", "pinpoint-pappname", "pinpoint-papptype", "pinpoint-host", "traceId").collect(Collectors.toCollection(ArrayList::new));
    private static final List<String> CALLBACK_HEADER_WHITELIST = Stream.of("routerkey", "security-token", "digi-compressed", "locale").collect(Collectors.toCollection(ArrayList::new));
    @Autowired
    private EAIExceptionHandler eaiExceptionHandler;
    private ExecutorService fasyncTaskExecutorService;
    private AtomicBoolean fasyncTaskExecutorServiceInitial = new AtomicBoolean(false);
    private Map<String, ExecutorService> fasyncTaskExecutorServiceMap = new HashMap<String, ExecutorService>();
    private Map<String, AtomicBoolean> fasyncTaskExecutorServiceInitialMap = new HashMap<String, AtomicBoolean>();
    @Autowired
    private DWContainerContext containerContext;
    @Autowired
    private DWEAIHeaderRepository eaiHeaderRepository;
    @Autowired
    private DWEAIProperties properties;
    @Autowired
    Environment environment;
    @Autowired(required=false)
    @Qualifier(value="fasyncMongo")
    private MongoClient mongoClient;
    @Autowired(required=false)
    @Qualifier(value="redisTemplate")
    private RedisTemplate<String, Object> redis;
    @Autowired(required=false)
    EaiCallbackArarmService eaiCallbackArarmService;
    @Autowired(required=false)
    @Qualifier(value="dwEaiFasyncTaskService")
    FasyncTaskService dwEaiFasyncTaskService;
    @Autowired(required=false)
    @Qualifier(value="dwEaiServiceInstanceService")
    ServiceInstanceService dwEaiServiceInstanceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callback() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        String digiSrvver = this.properties.getHostVer();
        Object result = null;
        DigiSrvcode digiSrvcode = DigiSrvcode.success;
        String parentDigiReqid = this.getParentDigiReqid();
        if (null != this.eaiCallbackArarmService) {
            this.eaiCallbackArarmService.ackCallBack(new EAICallbackDelayed(this.getDigiReqid()));
        }
        Map<String, Object> requestHeader = this.getRequestHeader();
        Object invokeResult = null;
        try {
            FindIterable findIterable;
            DWTargetAPI api = (DWTargetAPI)request.getAttribute(KEY_TARGET_API);
            DWParameters apiParameters = (DWParameters)request.getAttribute("targetParameters");
            Map parameters = ((DWDefaultParameters)apiParameters).getPararmeters();
            Map headers = parameters.getOrDefault(KEY_HEADERS, new HashMap());
            boolean parameterKeyInRedis = false;
            if (this.redis != null) {
                parameterKeyInRedis = this.redis.hasKey((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid));
            }
            if (parameterKeyInRedis) {
                Set keys = this.redis.opsForHash().keys((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid));
                for (Object key : keys) {
                    String chainParameter = (String)this.redis.opsForHash().get((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid), key);
                    headers.put((String)key + "-parameter", chainParameter);
                }
            } else if (this.mongoClient != null) {
                MongoCollection<Document> collection = this.getCollection(parentDigiReqid);
                long count = collection.countDocuments(Filters.eq((String)"key", (Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)));
                if (count > 0L) {
                    FindIterable findIterable2 = collection.find(Filters.eq((String)"key", (Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)));
                    for (Document document : findIterable2) {
                        boolean delete = document.getBoolean((Object)"delete", false);
                        if (delete) continue;
                        String hashKey = document.getString((Object)"hashKey");
                        String chainParameter = document.getString((Object)"value");
                        headers.put(hashKey + "-parameter", chainParameter);
                    }
                }
                MongoCollection<Document> filesCollection = this.getFilesCollection(parentDigiReqid);
                GridFSBucket gridFSBucket = this.getGridFSBucket(parentDigiReqid);
                long filesCollectionCount = filesCollection.countDocuments(Filters.eq((String)"filename", (Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)));
                if (filesCollectionCount > 0L) {
                    FindIterable findIterable3 = filesCollection.find(Filters.eq((String)"filename", (Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)));
                    for (Document document : findIterable3) {
                        boolean delete = document.getBoolean((Object)"delete", false);
                        if (delete) continue;
                        ObjectId oid = document.getObjectId((Object)"_id");
                        String hashKey = document.getString((Object)"hashKey");
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        gridFSBucket.downloadToStream(oid, (OutputStream)byteArrayOutputStream);
                        String chainParameter = byteArrayOutputStream.toString();
                        headers.put(hashKey + "-parameter", chainParameter);
                    }
                }
            }
            boolean historyKeyInRedis = false;
            if (this.redis != null) {
                historyKeyInRedis = this.redis.hasKey((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid));
            }
            if (historyKeyInRedis) {
                Set keys = this.redis.opsForHash().keys((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid));
                for (Object key : keys) {
                    String chainHistory = (String)this.redis.opsForHash().get((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid), key);
                    headers.put((String)key + "-history", chainHistory);
                }
            } else if (this.mongoClient != null) {
                MongoCollection<Document> collection = this.getCollection(parentDigiReqid);
                long count = collection.countDocuments(Filters.eq((String)"key", (Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)));
                if (count > 0L) {
                    FindIterable findIterable4 = collection.find(Filters.eq((String)"key", (Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)));
                    for (Document document : findIterable4) {
                        boolean delete = document.getBoolean((Object)"delete", false);
                        if (delete) continue;
                        String hashKey = document.getString((Object)"hashKey");
                        String chainParameter = document.getString((Object)"value");
                        headers.put(hashKey + "-history", chainParameter);
                    }
                }
                MongoCollection<Document> filesCollection = this.getFilesCollection(parentDigiReqid);
                GridFSBucket gridFSBucket = this.getGridFSBucket(parentDigiReqid);
                long filesCollectionCount = filesCollection.countDocuments(Filters.eq((String)"filename", (Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)));
                if (filesCollectionCount > 0L) {
                    findIterable = filesCollection.find(Filters.eq((String)"filename", (Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)));
                    for (Document document : findIterable) {
                        boolean delete = document.getBoolean((Object)"delete", false);
                        if (delete) continue;
                        ObjectId oid = document.getObjectId((Object)"_id");
                        String hashKey = document.getString((Object)"hashKey");
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        gridFSBucket.downloadToStream(oid, (OutputStream)byteArrayOutputStream);
                        String chainParameter = byteArrayOutputStream.toString();
                        headers.put(hashKey + "-history", chainParameter);
                    }
                }
            }
            parameters.put(KEY_HEADERS, headers);
            apiParameters = new DWDefaultParameters(parameters);
            DWJsonViewGsonProvider.initCurrentViewInfo((Method)api.getMethod().getMethod());
            invokeResult = this.containerContext.invoke(api, apiParameters, profile);
            if (invokeResult != null && invokeResult.getClass().equals(DWEAIResult.class)) {
                digiSrvcode = ((DWEAIResult)invokeResult).getDigiSrvcodeOrDefault(DigiSrvcode.success);
                result = DWJsonViewGsonProvider.toJson((Object)invokeResult, DWEAIResult.class);
            } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIChainProgressResult.class)) {
                DWEAIChainProgressResult chainProgressResult = (DWEAIChainProgressResult)invokeResult;
                digiSrvcode = chainProgressResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                Map chainParameter = chainProgressResult.getChainParameter();
                String callback = this.getCallbackId();
                this.attachChainParameter(chainParameter, parentDigiReqid, callback);
                DWEAIResult dwEaiResult = chainProgressResult.getDWEAIResult();
                result = DWJsonViewGsonProvider.toJson((Object)dwEaiResult, DWEAIResult.class);
                if (this.redis != null) {
                    this.redis.opsForHash().put((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid), (Object)callback, result);
                    this.redis.expire((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid), this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
                }
                if (this.mongoClient != null) {
                    MongoCollection<Document> collection = this.getCollection(parentDigiReqid);
                    long expireAfter = this.getExpireAfter();
                    document = new Document("key", (Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)).append("hashKey", (Object)callback).append("value", result).append("expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter));
                    collection.insertOne((Object)document);
                }
            } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIFasyncChainEndResult.class)) {
                Object mongoValue;
                boolean delete;
                MongoCollection<Document> collection;
                Document document;
                DWEAIFasyncChainEndResult fasyncChainEndResult = (DWEAIFasyncChainEndResult)invokeResult;
                digiSrvcode = fasyncChainEndResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                CallbackTask callbackTask = fasyncChainEndResult.getCallbackTask();
                DWServiceContext finalContext = DWServiceContext.getContext().deepClone();
                DWSecurityContext finalSecurityContext = DWSecurityContext.getSecurityContext().deepClone();
                Map redisCallbackHeader = null;
                Object redisValue = null;
                if (this.redis != null && (redisValue = this.redis.opsForValue().get((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + parentDigiReqid))) != null) {
                    redisCallbackHeader = (Map)redisValue;
                }
                if (this.mongoClient != null && redisValue == null && (document = (Document)(findIterable = (collection = this.getCollection(parentDigiReqid)).find(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + parentDigiReqid)))).first()) != null && !(delete = document.getBoolean((Object)"delete", false)) && (mongoValue = document.get((Object)"value", Map.class)) != null) {
                    redisCallbackHeader = (Map)mongoValue;
                }
                if (redisCallbackHeader == null || redisCallbackHeader.isEmpty()) {
                    requestHeader.remove("digi-callback-url");
                    requestHeader.remove("digi-callback-servicenameurl");
                    requestHeader.remove("digi-callback-callback");
                    requestHeader.remove("digi-callback-local-url");
                }
                Map<String, Object> callbackHeader = redisCallbackHeader == null || redisCallbackHeader.isEmpty() ? new HashMap<String, Object>(requestHeader) : redisCallbackHeader;
                Locale locale = LocaleContextHolder.getLocale();
                String currentModule = DWServiceContext.getContext().getGroupName();
                DWServiceChainContext serviceChainContext = DWServiceChainContext.getContext();
                String pTxId = ThreadContext.get((String)"PtxId");
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                try {
                    executorService.submit(() -> {
                        try {
                            LocaleContextHolder.setLocale((Locale)locale);
                            DWModuleClassLoader.setCurrentModuleName((String)currentModule);
                            DWServiceChainContext.recovery((DWServiceChainContext)serviceChainContext);
                            ThreadContext.put((String)"PtxId", (String)pTxId);
                            DWServiceContext.setContext((DWServiceContext)finalContext);
                            DWSecurityContext.setSecurityContext((DWSecurityContext)finalSecurityContext);
                            DWEAIFasyncTaskResult eaiFasyncTaskResult = fasyncChainEndResult.getDWEAIFasyncTaskResult();
                            DWServiceContext.getContext().setRequestHeader(callbackHeader);
                            this.onEaiCallback(parentDigiReqid, eaiFasyncTaskResult, callbackTask, callbackHeader);
                        }
                        catch (Throwable e) {
                            DWServiceContext.getContext().setRequestHeader(callbackHeader);
                            this.onFasyncException(e, parentDigiReqid, callbackTask, callbackHeader);
                        }
                        finally {
                            this.clearChain(parentDigiReqid);
                        }
                    });
                }
                finally {
                    if (executorService != null) {
                        // empty if block
                    }
                }
                DWEAIResult dwEaiResult = fasyncChainEndResult.getDWEAIResult();
                result = DWJsonViewGsonProvider.toJson((Object)dwEaiResult, DWEAIResult.class);
            } else if (invokeResult != null && invokeResult.getClass().equals(DWEAIChainEndResult.class)) {
                DWEAIChainEndResult chainEndResult = (DWEAIChainEndResult)invokeResult;
                digiSrvcode = chainEndResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                DWEAIResult dwEaiResult = chainEndResult.getDWEAIResult();
                result = DWJsonViewGsonProvider.toJson((Object)dwEaiResult, DWEAIResult.class);
                DWEAIChainTotalResult chainTotalResult = chainEndResult.getChainTotalResult();
                String totalResult = DWJsonViewGsonProvider.toJson((Object)chainTotalResult, DWEAIChainTotalResult.class);
                if (this.redis != null) {
                    this.redis.opsForValue().set((Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid), (Object)totalResult, this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
                }
                if (this.mongoClient != null) {
                    MongoCollection<Document> collection = this.getCollection(parentDigiReqid);
                    long expireAfter = this.getExpireAfter();
                    document = new Document("key", (Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid)).append("value", (Object)totalResult).append("expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter));
                    collection.insertOne((Object)document);
                }
            } else if (invokeResult instanceof Map) {
                Map mapResult = (Map)invokeResult;
                if (mapResult.containsKey("std_data")) {
                    result = DWJsonViewGsonProvider.toJson((Object)invokeResult);
                } else {
                    DWEAIResult dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                    result = DWJsonViewGsonProvider.toJson((Object)dwEaiResult, DWEAIResult.class);
                }
            } else {
                result = invokeResult;
            }
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, digiSrvcode.value());
        }
        catch (Throwable e) {
            try {
                MongoCollection<Document> collection;
                long count;
                response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
                response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.failure.value());
                String code = "-1";
                String sqlCode = "";
                String description = null;
                Map parameter = new HashMap();
                String message = null;
                String stacktrace = null;
                boolean isDwEaiException = false;
                DWEaiException eaiException = new DWEaiException();
                List throwableList = ExceptionUtils.getThrowableList((Throwable)e);
                for (Throwable throwable : throwableList) {
                    if (!(throwable instanceof DWEaiException)) continue;
                    eaiException = (DWEaiException)throwable;
                    isDwEaiException = true;
                }
                if (!isDwEaiException) {
                    eaiException = this.eaiExceptionHandler.parse(e);
                }
                String defaultDescription = this.getRootCausePureMessage(e);
                String defaultMessage = this.getRootCauseMessage(e);
                String defaultStacktrace = this.getStacktrace(e);
                code = eaiException.getCode();
                sqlCode = eaiException.getSqlCode();
                description = eaiException.getDescription(defaultDescription);
                parameter = eaiException.getParameter();
                message = eaiException.getMessage(defaultMessage);
                stacktrace = eaiException.getStacktrace(defaultStacktrace);
                DWEAIErrorResult dwEaiResult = new DWEAIErrorResult(code, sqlCode, description, parameter);
                dwEaiResult.setMessage(message);
                dwEaiResult.setErrorList(eaiException.getErrorList());
                dwEaiResult.setErrorInstructors(eaiException.getInstructors());
                dwEaiResult.setStacktrace(stacktrace);
                result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
                boolean hasSyncKey = false;
                boolean hasFasyncKey = false;
                if (this.redis != null) {
                    hasSyncKey = this.redis.hasKey((Object)(CHAIN_PROGRESS_SYNC_PREFIX + parentDigiReqid));
                }
                if (this.mongoClient != null && !hasSyncKey && (count = (collection = this.getCollection(parentDigiReqid)).countDocuments(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_SYNC_PREFIX + parentDigiReqid)))) > 0L) {
                    hasSyncKey = true;
                }
                if (!hasSyncKey) {
                    if (this.redis != null) {
                        hasFasyncKey = this.redis.hasKey((Object)(CHAIN_PROGRESS_FASYNC_PREFIX + parentDigiReqid));
                    }
                    if (this.mongoClient != null && !hasFasyncKey && (count = (collection = this.getCollection(parentDigiReqid)).countDocuments(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_FASYNC_PREFIX + parentDigiReqid)))) > 0L) {
                        hasFasyncKey = true;
                    }
                }
                if (hasSyncKey) {
                    if (this.redis != null) {
                        this.redis.opsForValue().set((Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid), result, this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
                    }
                    if (this.mongoClient != null) {
                        collection = this.getCollection(parentDigiReqid);
                        long expireAfter = this.getExpireAfter();
                        Document document = new Document("key", (Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid)).append("value", result).append("expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter));
                        collection.insertOne((Object)document);
                    }
                } else if (hasFasyncKey) {
                    Object mongoValue;
                    boolean delete;
                    MongoCollection<Document> collection2;
                    FindIterable findIterable;
                    Document document;
                    Map redisCallbackHeader = null;
                    Object redisValue = null;
                    if (this.redis != null && (redisValue = this.redis.opsForValue().get((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + parentDigiReqid))) != null) {
                        redisCallbackHeader = (Map)redisValue;
                    }
                    if (this.mongoClient != null && redisValue == null && (document = (Document)(findIterable = (collection2 = this.getCollection(parentDigiReqid)).find(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + parentDigiReqid)))).first()) != null && !(delete = document.getBoolean((Object)"delete", false)) && (mongoValue = document.get((Object)"value", Map.class)) != null) {
                        redisCallbackHeader = (Map)mongoValue;
                    }
                    Map<String, Object> callbackHeader = redisCallbackHeader == null || redisCallbackHeader.isEmpty() ? new HashMap<String, Object>(requestHeader) : redisCallbackHeader;
                    DWServiceContext.getContext().setRequestHeader(callbackHeader);
                    this.onFasyncException(e, parentDigiReqid, null, redisCallbackHeader);
                    this.clearChain(parentDigiReqid);
                }
                this.logException(e);
            }
            catch (Throwable throwable) {
                if (DWServiceChainUtils.isServiceChainEnabled()) {
                    requestHeader.put(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
                }
                this.logEspUrl("response", invokeResult, requestHeader);
                throw throwable;
            }
            if (DWServiceChainUtils.isServiceChainEnabled()) {
                requestHeader.put(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
            }
            this.logEspUrl("response", invokeResult, requestHeader);
        }
        if (DWServiceChainUtils.isServiceChainEnabled()) {
            requestHeader.put(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
        }
        this.logEspUrl("response", invokeResult, requestHeader);
        HttpHeaders responseHeaders = new HttpHeaders();
        if (DWServiceChainUtils.isServiceChainEnabled()) {
            responseHeaders.add(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)200).headers(responseHeaders)).body(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eai() {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = Collections.emptyMap();
        }
        String digiSrvver = this.properties.getHostVer();
        Object result = null;
        DigiSrvcode digiSrvcode = DigiSrvcode.success;
        try {
            DWTargetAPI api = (DWTargetAPI)request.getAttribute(KEY_TARGET_API);
            DWParameters apiParameters = (DWParameters)request.getAttribute("targetParameters");
            DWJsonViewGsonProvider.initCurrentViewInfo((Method)api.getMethod().getMethod());
            Object invokeResult = this.containerContext.invoke(api, apiParameters, profile);
            String digiReqid = this.getDigiReqid();
            Map<String, Object> requestHeader = this.getRequestHeader();
            if (invokeResult.getClass().equals(DWEAIResult.class)) {
                digiSrvcode = ((DWEAIResult)invokeResult).getDigiSrvcodeOrDefault(DigiSrvcode.success);
                result = DWJsonViewGsonProvider.toJson((Object)invokeResult, DWEAIResult.class);
                this.addSyncResponseHeader(response, digiReqid);
            } else if (invokeResult.getClass().equals(DWEAIChainResult.class)) {
                boolean delete;
                MongoCollection<Document> collection;
                FindIterable findIterable;
                Document document;
                DWEAIChainResult chainResult = (DWEAIChainResult)invokeResult;
                Map chainParameter = chainResult.getChainParameter();
                String digiServiceName = DWServiceContext.getContext().getDigiServiceName();
                this.attachChainParameter(chainParameter, digiReqid, digiServiceName);
                if (this.redis != null) {
                    this.redis.opsForValue().set((Object)(CHAIN_PROGRESS_SYNC_PREFIX + digiReqid), (Object)true, this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
                }
                if (this.mongoClient != null) {
                    MongoCollection<Document> collection2 = this.getCollection(digiReqid);
                    long expireAfter = this.getExpireAfter();
                    document = new Document("key", (Object)(CHAIN_PROGRESS_SYNC_PREFIX + digiReqid)).append("value", (Object)true).append("expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter));
                    collection2.insertOne((Object)document);
                }
                boolean hasKey = false;
                while (!hasKey) {
                    MongoCollection<Document> collection3;
                    long coout;
                    if (this.redis != null) {
                        hasKey = this.redis.hasKey((Object)(CHAIN_SIGNAL_PREFIX + digiReqid));
                    }
                    if (this.mongoClient == null || hasKey || (coout = (collection3 = this.getCollection(digiReqid)).countDocuments(Filters.eq((String)"key", (Object)(CHAIN_SIGNAL_PREFIX + digiReqid)))) <= 0L) continue;
                    hasKey = true;
                }
                if (this.redis != null) {
                    result = this.redis.opsForValue().get((Object)(CHAIN_SIGNAL_PREFIX + digiReqid));
                }
                if (this.mongoClient != null && result == null && (document = (Document)(findIterable = (collection = this.getCollection(digiReqid)).find(Filters.eq((String)"key", (Object)(CHAIN_SIGNAL_PREFIX + digiReqid)))).first()) != null && !(delete = document.getBoolean((Object)"delete", false))) {
                    result = document.getString((Object)"value");
                }
                this.clearChain(digiReqid);
            } else if (invokeResult.getClass().equals(DWEAIFasyncResult.class)) {
                Object mongoValue;
                boolean delete;
                MongoCollection<Document> collection;
                FindIterable findIterable;
                Document document;
                DWEAIFasyncResult fasyncResult = (DWEAIFasyncResult)invokeResult;
                digiSrvcode = fasyncResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                FasyncTask fasyncTask = fasyncResult.getFasyncTask();
                CallbackTask callbackTask = fasyncResult.getCallbackTask();
                DWServiceContext finalContext = DWServiceContext.getContext().deepClone();
                DWSecurityContext finalSecurityContext = DWSecurityContext.getSecurityContext().deepClone();
                Map redisCallbackHeader = null;
                Object redisValue = null;
                if (this.redis != null && (redisValue = this.redis.opsForValue().get((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid))) != null) {
                    redisCallbackHeader = (Map)redisValue;
                }
                if (this.mongoClient != null && redisValue == null && (document = (Document)(findIterable = (collection = this.getCollection(digiReqid)).find(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid)))).first()) != null && !(delete = document.getBoolean((Object)"delete", false)) && (mongoValue = document.get((Object)"value", Map.class)) != null) {
                    redisCallbackHeader = (Map)mongoValue;
                }
                Map<String, Object> callbackHeader = redisCallbackHeader == null || redisCallbackHeader.isEmpty() ? new HashMap<String, Object>(requestHeader) : redisCallbackHeader;
                Locale locale = LocaleContextHolder.getLocale();
                String currentModule = DWServiceContext.getContext().getGroupName();
                DWServiceChainContext serviceChainContext = DWServiceChainContext.getContext();
                String pTxId = ThreadContext.get((String)"PtxId");
                ExecutorService executorService = this.getFasyncTaskExecutorService(fasyncResult);
                this.insertFasyncTask(digiReqid, requestHeader, request, fasyncResult);
                try {
                    executorService.submit(() -> {
                        try {
                            this.updateFasyncTask(digiReqid, fasyncResult);
                            LocaleContextHolder.setLocale((Locale)locale);
                            DWModuleClassLoader.setCurrentModuleName((String)currentModule);
                            DWServiceChainContext.recovery((DWServiceChainContext)serviceChainContext);
                            ThreadContext.put((String)"PtxId", (String)pTxId);
                            DWServiceContext.setContext((DWServiceContext)finalContext);
                            DWSecurityContext.setSecurityContext((DWSecurityContext)finalSecurityContext);
                            DWEAIFasyncTaskResult eaiFasyncTaskResult = fasyncTask.execute();
                            DWServiceContext.getContext().setRequestHeader(callbackHeader);
                            this.onEaiCallback(digiReqid, eaiFasyncTaskResult, callbackTask, callbackHeader, true);
                        }
                        catch (Throwable e) {
                            DWServiceContext.getContext().setRequestHeader(callbackHeader);
                            this.onFasyncException(e, digiReqid, callbackTask, callbackHeader);
                        }
                        finally {
                            this.clearChain(digiReqid);
                            this.deleteFasyncTask(digiReqid, fasyncResult);
                            this.shutDownFasyncTaskExecutorService(executorService, fasyncResult);
                        }
                    });
                }
                finally {
                    if (executorService != null) {
                        // empty if block
                    }
                }
                DWEAIResult dwEaiResult = fasyncResult.getDWEAIResult();
                result = DWJsonViewGsonProvider.toJson((Object)dwEaiResult, DWEAIResult.class);
            } else if (invokeResult.getClass().equals(DWEAIFasyncChainResult.class)) {
                DWEAIFasyncChainResult fasyncChainResult = (DWEAIFasyncChainResult)invokeResult;
                digiSrvcode = fasyncChainResult.getDigiSrvcodeOrDefault(DigiSrvcode.success);
                FasyncChainTask fasyncChainTask = fasyncChainResult.getFasyncChainTask();
                CallbackTask callbackTask = fasyncChainResult.getCallbackTaskOnException();
                Map chainParameter = fasyncChainResult.getChainParameter();
                String digiServiceName = this.getDigiServiceName();
                this.attachChainParameter(chainParameter, digiReqid, digiServiceName);
                if (this.redis != null) {
                    this.redis.opsForValue().set((Object)(CHAIN_PROGRESS_FASYNC_PREFIX + digiReqid), (Object)true, this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
                }
                if (this.mongoClient != null) {
                    MongoCollection<Document> collection = this.getCollection(digiReqid);
                    long expireAfter = this.getExpireAfter();
                    Document document = new Document("key", (Object)(CHAIN_PROGRESS_FASYNC_PREFIX + digiReqid)).append("value", (Object)true).append("expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter));
                    collection.insertOne((Object)document);
                }
                DWServiceContext finalContext = DWServiceContext.getContext().deepClone();
                DWSecurityContext finalSecurityContext = DWSecurityContext.getSecurityContext().deepClone();
                Locale locale = LocaleContextHolder.getLocale();
                String currentModule = DWServiceContext.getContext().getGroupName();
                DWServiceChainContext serviceChainContext = DWServiceChainContext.getContext();
                String pTxId = ThreadContext.get((String)"PtxId");
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                try {
                    executorService.submit(() -> {
                        try {
                            LocaleContextHolder.setLocale((Locale)locale);
                            DWModuleClassLoader.setCurrentModuleName((String)currentModule);
                            DWServiceChainContext.recovery((DWServiceChainContext)serviceChainContext);
                            ThreadContext.put((String)"PtxId", (String)pTxId);
                            DWServiceContext.setContext((DWServiceContext)finalContext);
                            DWSecurityContext.setSecurityContext((DWSecurityContext)finalSecurityContext);
                            fasyncChainTask.execute();
                        }
                        catch (Throwable e) {
                            Object mongoValue;
                            boolean delete;
                            MongoCollection<Document> collection;
                            FindIterable findIterable;
                            Document document;
                            Map redisCallbackHeader = null;
                            Object redisValue = null;
                            if (this.redis != null && (redisValue = this.redis.opsForValue().get((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid))) != null) {
                                redisCallbackHeader = (Map)redisValue;
                            }
                            if (this.mongoClient != null && redisValue == null && (document = (Document)(findIterable = (collection = this.getCollection(digiReqid)).find(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid)))).first()) != null && !(delete = document.getBoolean((Object)"delete", false)) && (mongoValue = document.get((Object)"value", Map.class)) != null) {
                                redisCallbackHeader = (Map)mongoValue;
                            }
                            Map callbackHeader = redisCallbackHeader == null || redisCallbackHeader.isEmpty() ? new HashMap(requestHeader) : redisCallbackHeader;
                            DWServiceContext.getContext().setRequestHeader(callbackHeader);
                            this.onFasyncException(e, digiReqid, callbackTask, redisCallbackHeader);
                        }
                    });
                }
                finally {
                    if (executorService != null) {
                        // empty if block
                    }
                }
                DWEAIResult dwEaiResult = fasyncChainResult.getDWEAIResult();
                result = DWJsonViewGsonProvider.toJson((Object)dwEaiResult, DWEAIResult.class);
            } else if (invokeResult instanceof Map) {
                Map mapResult = (Map)invokeResult;
                if (mapResult.containsKey("std_data")) {
                    result = DWJsonViewGsonProvider.toJson((Object)invokeResult);
                } else {
                    DWEAIResult dwEaiResult = new DWEAIResult("0", "", "", (Map)invokeResult);
                    result = DWJsonViewGsonProvider.toJson((Object)dwEaiResult, dwEaiResult.getClass());
                }
                this.addSyncResponseHeader(response, digiReqid);
            } else {
                result = invokeResult;
                this.addSyncResponseHeader(response, digiReqid);
            }
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, digiSrvcode.value());
        }
        catch (Throwable e) {
            response.addHeader(KEY_DIGI_SRVVER, digiSrvver);
            response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.failure.value());
            String code = "-1";
            String sqlCode = "";
            String description = null;
            Map parameter = new HashMap();
            String message = null;
            String stacktrace = null;
            boolean isDwEaiException = false;
            DWEaiException eaiException = new DWEaiException();
            List throwableList = ExceptionUtils.getThrowableList((Throwable)e);
            for (Throwable throwable : throwableList) {
                if (!(throwable instanceof DWEaiException)) continue;
                eaiException = (DWEaiException)throwable;
                isDwEaiException = true;
            }
            if (!isDwEaiException) {
                eaiException = this.eaiExceptionHandler.parse(e);
            }
            String defaultDescription = this.getRootCausePureMessage(e);
            String defaultMessage = this.getRootCauseMessage(e);
            String defaultStacktrace = this.getStacktrace(e);
            code = eaiException.getCode();
            sqlCode = eaiException.getSqlCode();
            description = eaiException.getDescription(defaultDescription);
            parameter = eaiException.getParameter();
            message = eaiException.getMessage(defaultMessage);
            stacktrace = eaiException.getStacktrace(defaultStacktrace);
            DWEAIErrorResult dwEaiResult = new DWEAIErrorResult(code, sqlCode, description, parameter);
            dwEaiResult.setMessage(message);
            dwEaiResult.setErrorList(eaiException.getErrorList());
            dwEaiResult.setErrorInstructors(eaiException.getInstructors());
            dwEaiResult.setStacktrace(stacktrace);
            result = DWGsonProvider.getGson().toJson((Object)dwEaiResult, dwEaiResult.getClass());
            this.logException(e);
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        if (DWServiceChainUtils.isServiceChainEnabled()) {
            responseHeaders.add(DWServiceChainUtils.HEADER_KEY_SERVICE_CHAIN_TARGET_ID, DWServiceChainContext.getContext().getId());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)200).headers(responseHeaders)).body(result);
    }

    public Object syncProd() throws Exception {
        HttpServletRequest request = EaiInfoUtils.getRequest();
        String digiService = request.getHeader("digi-service");
        JSONObject digiServiceJo = new JSONObject(digiService);
        String name = digiServiceJo.getString("name");
        Map<Object, Object> result = new HashMap();
        HttpServletResponse response = EaiInfoUtils.getResponse();
        response.addHeader("Content-Type", "application/json; charset=UTF-8");
        switch (name) {
            case "getProdRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getProdRegInfo(this.environment, this.properties);
                break;
            }
            case "getSrvRegInfo": {
                response.addHeader("action", "reg");
                result = EaiInfoUtils.getSrvRegInfo(() -> ((DWEAIHeaderRepository)this.eaiHeaderRepository).getEaiServiceIdList(), this.properties);
                break;
            }
            case "doSyncProcess": {
                response.addHeader(KEY_DIGI_SRVCODE, "000");
                break;
            }
            case "doSrvProcess": {
                String doSrcProcessServiceId = this.properties.getSyncProdProperties().getDoSrvProcessServiceId();
                if (doSrcProcessServiceId == null || doSrcProcessServiceId.equals("")) break;
                result = this.executeSyncProdService(doSrcProcessServiceId, request, response);
                break;
            }
            case "doSrvTest": {
                String doSrcTestServiceId = this.properties.getSyncProdProperties().getDoSrvTestServiceId();
                if (doSrcTestServiceId == null || doSrcTestServiceId.equals("")) break;
                result = this.executeSyncProdService(doSrcTestServiceId, request, response);
                break;
            }
        }
        return result;
    }

    private String getRootCauseMessage(Throwable exception) {
        return ExceptionUtils.getRootCauseMessage((Throwable)exception);
    }

    private String getRootCausePureMessage(Throwable exception) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        Throwable targetCause = rootCause != null ? rootCause : exception;
        String message = targetCause.getMessage();
        if (message == null || message.isEmpty()) {
            message = targetCause.toString();
        }
        return message;
    }

    private String getStacktrace(Throwable exception) {
        return ExceptionUtils.getStackTrace((Throwable)exception);
    }

    private void clearChain(String parentDigiReqid) {
        if (this.redis != null) {
            this.redis.delete((Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid));
            this.redis.delete((Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid));
            this.redis.delete((Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid));
            this.redis.delete((Object)(CHAIN_PROGRESS_SYNC_PREFIX + parentDigiReqid));
            this.redis.delete((Object)(CHAIN_PROGRESS_FASYNC_PREFIX + parentDigiReqid));
            this.redis.delete((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + parentDigiReqid));
        }
        if (this.mongoClient != null) {
            long historyCount;
            MongoCollection<Document> collection = this.getCollection(parentDigiReqid);
            collection.deleteMany(Filters.eq((String)"key", (Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)));
            collection.deleteMany(Filters.eq((String)"key", (Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)));
            collection.deleteMany(Filters.eq((String)"key", (Object)(CHAIN_SIGNAL_PREFIX + parentDigiReqid)));
            collection.deleteMany(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_SYNC_PREFIX + parentDigiReqid)));
            collection.deleteMany(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_FASYNC_PREFIX + parentDigiReqid)));
            collection.deleteMany(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + parentDigiReqid)));
            MongoCollection<Document> filesCollection = this.getFilesCollection(parentDigiReqid);
            MongoCollection<Document> chunksCollection = this.getChunksCollection(parentDigiReqid);
            long parameterCount = filesCollection.countDocuments(Filters.eq((String)"filename", (Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)));
            if (parameterCount > 0L) {
                FindIterable findIterable = filesCollection.find(Filters.eq((String)"filename", (Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)));
                for (Document document : findIterable) {
                    ObjectId objectId = document.getObjectId((Object)"_id");
                    chunksCollection.deleteMany(Filters.eq((String)"files_id", (Object)objectId));
                    filesCollection.deleteMany(Filters.eq((String)"filename", (Object)(CHAIN_PARAMETER_PREFIX + parentDigiReqid)));
                }
            }
            if ((historyCount = filesCollection.countDocuments(Filters.eq((String)"filename", (Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)))) > 0L) {
                FindIterable findIterable = filesCollection.find(Filters.eq((String)"filename", (Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)));
                for (Document document : findIterable) {
                    ObjectId objectId = document.getObjectId((Object)"_id");
                    chunksCollection.deleteMany(Filters.eq((String)"files_id", (Object)objectId));
                    filesCollection.deleteMany(Filters.eq((String)"filename", (Object)(CHAIN_HISTORY_PREFIX + parentDigiReqid)));
                }
            }
        }
    }

    private void onFasyncException(Throwable e, String digiReqid, CallbackTask callbackTask, Map<String, Object> requestHeader) {
        this.logException(e);
        String code = "-1";
        String sqlCode = "";
        String description = this.getRootCauseMessage(e);
        if (DWServiceChainUtils.isServiceChainEnabled()) {
            DWServiceChainUtils.beforeInvokeEAICallbackAPI(requestHeader);
        }
        if (requestHeader.containsKey("digi-callback-servicenameurl") && e instanceof Exception) {
            HashMap resultJoNew = new HashMap();
            HashMap<String, String> executionJoNew = new HashMap<String, String>();
            executionJoNew.put("code", code);
            executionJoNew.put("sql_code", sqlCode);
            executionJoNew.put("description", description);
            HashMap stdDataJoNew = new HashMap();
            stdDataJoNew.put("execution", executionJoNew);
            stdDataJoNew.put("parameter", new HashMap());
            resultJoNew.put("std_data", stdDataJoNew);
            HashMap<String, Object> logHeader = new HashMap<String, Object>(requestHeader);
            logHeader.put(KEY_DIGI_SRVCODE, DigiSrvcode.failure.value());
            this.logEspUrl("request", resultJoNew, logHeader, null);
        }
        DWEAICallback eaiCallback = new DWEAICallback(DigiSrvcode.failure.value(), digiReqid, code, sqlCode, description, new HashMap());
        Map callbackResult = eaiCallback.execute();
        if (callbackTask != null) {
            Map headers = (Map)callbackResult.get(KEY_HEADERS);
            String messageBody = (String)callbackResult.get("messageBody");
            callbackTask.execute(headers, messageBody);
        }
    }

    private void onEaiCallback(String digiReqid, DWEAIFasyncTaskResult eaiFasyncTaskResult, CallbackTask callbackTask, Map<String, Object> requestHeader) {
        this.onEaiCallback(digiReqid, eaiFasyncTaskResult, callbackTask, requestHeader, false);
    }

    /*
     * Unable to fully structure code
     */
    private void onEaiCallback(String digiReqid, DWEAIFasyncTaskResult eaiFasyncTaskResult, CallbackTask callbackTask, Map<String, Object> requestHeader, boolean isLmcLog) {
        eaiCallback = new DWEAICallback(digiReqid, eaiFasyncTaskResult);
        eaiCallback.setDigiDatakey(eaiFasyncTaskResult.getDigiDatakey());
        eaiCallback.setCustomHeader(eaiFasyncTaskResult.getCustomHeader());
        eaiCallback.setCustomCallbackHeader(eaiFasyncTaskResult.getCustomCallbackHeader());
        callbackResult = null;
        if (requestHeader.containsKey("digi-callback-url") || requestHeader.containsKey("digi-callback-servicenameurl")) {
            if (DWServiceChainUtils.isServiceChainEnabled()) {
                DWServiceChainUtils.beforeInvokeEAICallbackAPI(requestHeader);
            }
            this.logEspUrl("request", eaiFasyncTaskResult, requestHeader);
            try {
                callbackResult = eaiCallback.decentralization(requestHeader, isLmcLog);
                if (callbackResult == null || !callbackResult.containsKey("eai-response-http-status") || (responseHttpStatus = callbackResult.get("eai-response-http-status")) == null || !(responseHttpStatus instanceof Integer)) ** GOTO lbl36
                httpStatus = (Integer)responseHttpStatus;
                responseHeader = (Map)callbackResult.get("headers");
                responseBody = (String)callbackResult.get("messageBody");
                if ((Integer)responseHttpStatus == 200) ** GOTO lbl36
                this.logCallbackResponseNone200(requestHeader, httpStatus, responseHeader, responseBody);
            }
            catch (Exception e) {
                this.logEspUrl("request", eaiFasyncTaskResult, requestHeader, e);
                throw e;
            }
        } else if (DWServiceChainUtils.isServiceChainEnabled()) {
            try {
                this.logEspLocalUrl("request", eaiFasyncTaskResult, requestHeader);
                customCallbackHeaderMap = eaiCallback.getCustomCallbackHeader();
                DWServiceChainUtils.beforeInvokeOutterAPI((boolean)true, (DWServiceChainInfoStorage)(DWServiceChainInfoStorage)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, put(K V ), (Ljava/lang/String;Ljava/lang/String;)V)((Map)customCallbackHeaderMap));
                eaiCallback.setCustomCallbackHeader(customCallbackHeaderMap);
                callbackResult = eaiCallback.execute();
            }
            catch (Exception e) {
                this.logEspLocalUrl("request", eaiFasyncTaskResult, requestHeader, e);
                EaiController.log.error((Object)"callback custom header can not attach service chain info!", (Throwable)e);
            }
        }
lbl36:
        // 7 sources

        if (callbackTask != null) {
            callbackHeaders = (Map)callbackResult.get("headers");
            callbackMessageBody = (String)callbackResult.get("messageBody");
            callbackTask.execute(callbackHeaders, callbackMessageBody);
        }
    }

    private void attachChainParameter(Map<String, Object> chainParameter, String digiReqid, String key) {
        String chainParameterString = DWJsonViewGsonProvider.toJson(chainParameter, Map.class);
        byte[] byteArray = chainParameterString.getBytes();
        int byteCount = byteArray.length;
        int sizeInMb = byteCount / 0x100000;
        if (this.redis != null) {
            this.redis.opsForHash().put((Object)(CHAIN_PARAMETER_PREFIX + digiReqid), (Object)key, (Object)chainParameterString);
            this.redis.expire((Object)(CHAIN_PARAMETER_PREFIX + digiReqid), this.properties.getRedisKeyExpireTime(), TimeUnit.SECONDS);
        }
        if (sizeInMb <= 12) {
            if (this.mongoClient != null) {
                MongoCollection<Document> collection = this.getCollection(digiReqid);
                long expireAfter = this.getExpireAfter();
                Document document = new Document("key", (Object)(CHAIN_PARAMETER_PREFIX + digiReqid)).append("hashKey", (Object)key).append("value", (Object)chainParameterString).append("expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter));
                collection.insertOne((Object)document);
            }
        } else {
            MongoCollection<Document> filesCollection = this.getFilesCollection(digiReqid);
            MongoCollection<Document> chunksCollection = this.getChunksCollection(digiReqid);
            GridFSBucket gridFSBucket = this.getGridFSBucket(digiReqid);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
            GridFSUploadOptions options = new GridFSUploadOptions().chunkSizeBytes(Integer.valueOf(261120));
            ObjectId id = gridFSBucket.uploadFromStream(CHAIN_PARAMETER_PREFIX + digiReqid, (InputStream)inputStream, options);
            long expireAfter = this.getExpireAfter();
            filesCollection.updateOne(Filters.eq((String)"_id", (Object)id), Updates.set((String)"expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter)));
            filesCollection.updateOne(Filters.eq((String)"_id", (Object)id), Updates.set((String)"hashKey", (Object)key));
            chunksCollection.updateMany(Filters.eq((String)"files_id", (Object)id), Updates.set((String)"expireAt", (Object)new Date(System.currentTimeMillis() + expireAfter)));
        }
    }

    private String getParentDigiReqid() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-callback-parent-reqid", "");
    }

    private String getCallbackId() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-callback-callback", "");
    }

    private String getDigiReqid() {
        return DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-reqid", "");
    }

    private Map<String, Object> getRequestHeader() {
        return DWServiceContext.getContext().getRequestHeader();
    }

    private String getDigiServiceName() {
        return DWServiceContext.getContext().getDigiServiceName();
    }

    private void logException(Throwable throwable) {
        try {
            String rootCauseMessage = this.getRootCauseMessage(throwable);
            String stacktrace = this.getStacktrace(throwable);
            HttpServletRequest request = EaiInfoUtils.getRequest();
            DWTargetAPI api = (DWTargetAPI)request.getAttribute(KEY_TARGET_API);
            DWHeader header = api.getHeader();
            DWMethod method = api.getMethod();
            String moduleName = header.getModuleName();
            String serviceName = header.getServiceName();
            String methodName = method.getMethodName();
            log.error((Object)String.format("[EaiController] module: %s, service: %s, method: %s", moduleName, serviceName, methodName));
            log.error((Object)String.format("[EaiController] root cause message: %s", rootCauseMessage));
            log.error((Object)String.format("[EaiController] stack trace: %s", stacktrace));
        }
        catch (Throwable ignore) {
            String stacktrace = this.getStacktrace(throwable);
            log.error((Object)String.format("[EaiController] on log exception: %s", stacktrace));
        }
    }

    private Map<String, Object> executeSyncProdService(String serviceId, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)request);
            String bodyString = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
            Map requestBody = (Map)DWGsonProvider.getGson().fromJson(bodyString, Map.class);
            TreeMap<String, String> requestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                requestHeaders.put((String)headerNames.nextElement(), request.getHeader(key));
            }
            SyncProdServiceVo syncProdServiceVoRequest = new SyncProdServiceVo(requestBody, requestHeaders);
            IEAISyncProdService syncProdService = null;
            if (serviceId.contains(":")) {
                String[] moduleNameAndServiceId = serviceId.split(":");
                syncProdService = (IEAISyncProdService)DWModuleSpringUtils.getBean((String)moduleNameAndServiceId[0], (String)moduleNameAndServiceId[1]);
            } else {
                syncProdService = (IEAISyncProdService)SpringContextUtils.getBean((String)serviceId);
            }
            SyncProdServiceVo syncProdServiceVoResult = syncProdService.execute(syncProdServiceVoRequest);
            if (syncProdServiceVoResult.getHeaders() != null) {
                syncProdServiceVoResult.getHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
            }
            if (syncProdServiceVoResult.getDigiSrvCode() != null) {
                response.addHeader(KEY_DIGI_SRVCODE, syncProdServiceVoResult.getDigiSrvCode());
            } else {
                response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.success.value());
            }
            result = syncProdServiceVoResult.getBody();
        }
        catch (Exception e) {
            log.error((Object)"executeSyncProdService exception", (Throwable)e);
            response.addHeader(KEY_DIGI_SRVCODE, DigiSrvcode.failure.value());
            result.put("message", this.getRootCauseMessage(e));
            result.put("stacktrace", this.getStacktrace(e));
        }
        return result;
    }

    private void logCallbackResponseNone200(Map<String, Object> requestHeader, int responseHttpStatusCode, Map<String, String> responseHeader, String responseBody) {
        DapLogUtils.DapLogCallbackResponseExtraInfo extraLogInfo = new DapLogUtils.DapLogCallbackResponseExtraInfo(responseHttpStatusCode, responseHeader, responseBody);
        this.logEspUrl("noneHttpStatus200", extraLogInfo, requestHeader, null);
    }

    private void logEspUrl(String logType, Object invokeResult, Map<String, Object> requestHeader) {
        this.logEspUrl(logType, invokeResult, requestHeader, null);
    }

    private void logEspUrl(String logType, Object invokeResult, Map<String, Object> requestHeader, Exception exInInvocation) {
        try {
            if (StringUtils.isBlank((CharSequence)requestHeader.getOrDefault("digi-callback-logurl", "").toString()) && StringUtils.isBlank((CharSequence)requestHeader.getOrDefault("digi-callback-url", "").toString())) {
                return;
            }
            DapLogService.saveLog((DapLogDto)DapLogUtils.getDapCallbackLog((String)logType, (Object)invokeResult, requestHeader, (Exception)exInInvocation));
        }
        catch (Throwable e) {
            log.error((Object)"send esp log fail e:", e);
        }
    }

    private void logEspLocalUrl(String logType, Object invokeResult, Map<String, Object> requestHeader) {
        this.logEspLocalUrl(logType, invokeResult, requestHeader, null);
    }

    private void logEspLocalUrl(String logType, Object invokeResult, Map<String, Object> requestHeader, Exception exInInvocation) {
        try {
            if (StringUtils.isBlank((CharSequence)requestHeader.getOrDefault("digi-callback-local-url", "").toString())) {
                return;
            }
            DapLogService.saveLog((DapLogDto)DapLogUtils.getDapCallbackLog((String)logType, (Object)invokeResult, requestHeader, (Exception)exInInvocation));
        }
        catch (Throwable e) {
            log.error((Object)"send esp local route log fail e:", e);
        }
    }

    private void addSyncResponseHeader(HttpServletResponse response, String digiReqid) {
        Object mongoValue;
        boolean delete;
        MongoCollection<Document> collection;
        FindIterable findIterable;
        Document document;
        Map redisHeader = null;
        Object redisValue = null;
        if (this.redis != null && (redisValue = this.redis.opsForValue().get((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid))) != null) {
            redisHeader = (Map)redisValue;
        }
        if (this.mongoClient != null && redisValue == null && (document = (Document)(findIterable = (collection = this.getCollection(digiReqid)).find(Filters.eq((String)"key", (Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid)))).first()) != null && !(delete = document.getBoolean((Object)"delete", false)) && (mongoValue = document.get((Object)"value", Map.class)) != null) {
            redisHeader = (Map)mongoValue;
        }
        if (this.redis != null) {
            this.redis.delete((Object)(CHAIN_PROGRESS_FASYNC_HEADER_PREFIX + digiReqid));
        }
        Map prepareForResponseHeader = redisHeader == null || redisHeader.isEmpty() ? new HashMap() : redisHeader;
        for (Map.Entry entry : prepareForResponseHeader.entrySet()) {
            String key = (String)entry.getKey();
            if (!SERVICE_HEADER_WHITELIST.contains(key) && !key.startsWith("digi-callback-")) continue;
            Object value = entry.getValue();
            String stringValue = "";
            if (value != null) {
                stringValue = String.valueOf(value);
            }
            response.addHeader(key, stringValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getFasyncTaskExecutorService(DWEAIFasyncResult fasyncResult) {
        if (this.enableFasyncTaskPool(fasyncResult)) {
            String fasyncTaskPoolName = fasyncResult.getFasyncTaskPoolName();
            if (fasyncTaskPoolName == null) {
                if (this.fasyncTaskExecutorService == null) {
                    AtomicBoolean atomicBoolean = this.fasyncTaskExecutorServiceInitial;
                    synchronized (atomicBoolean) {
                        if (this.fasyncTaskExecutorService == null) {
                            this.fasyncTaskExecutorService = Executors.newFixedThreadPool(this.properties.getFasyncTaskExecutorServiceThreads(), new EaiAsyncTaskThreadFactory(this.properties));
                        }
                    }
                }
                return this.fasyncTaskExecutorService;
            }
            if (!this.fasyncTaskExecutorServiceMap.containsKey(fasyncTaskPoolName)) {
                AtomicBoolean fasyncTaskExecutorServiceInitialIndivial;
                if (!this.fasyncTaskExecutorServiceInitialMap.containsKey(fasyncTaskPoolName)) {
                    this.fasyncTaskExecutorServiceInitialMap.put(fasyncTaskPoolName, new AtomicBoolean(false));
                }
                AtomicBoolean atomicBoolean = fasyncTaskExecutorServiceInitialIndivial = this.fasyncTaskExecutorServiceInitialMap.get(fasyncTaskPoolName);
                synchronized (atomicBoolean) {
                    if (!this.fasyncTaskExecutorServiceMap.containsKey(fasyncTaskPoolName)) {
                        this.fasyncTaskExecutorServiceMap.put(fasyncTaskPoolName, Executors.newFixedThreadPool(fasyncResult.getFasyncTaskPoolSize(), new EaiAsyncTaskThreadFactory(this.properties, fasyncTaskPoolName)));
                    }
                }
            }
            return this.fasyncTaskExecutorServiceMap.get(fasyncTaskPoolName);
        }
        return Executors.newSingleThreadExecutor();
    }

    private boolean enableFasyncTaskPool(DWEAIFasyncResult fasyncResult) {
        return this.properties.getFasyncTaskPoolEnable() || fasyncResult.isFasyncRateLimit();
    }

    private void insertFasyncTask(String digiReqId, Map<String, Object> requestHeader, HttpServletRequest request, DWEAIFasyncResult fasyncResult) {
        if (this.enableFasyncTaskPool(fasyncResult) && this.enableFasyncTaskPoolPersistence()) {
            try {
                DWDefaultParameters parameters = (DWDefaultParameters)request.getAttribute("targetParameters");
                String messageBody = (String)parameters.getPararmeters().get("messageBody");
                Map profile = DWServiceContext.getContext().getProfile();
                String tenantId = (String)profile.get("tenantId");
                Enumeration headerNames = request.getHeaderNames();
                TreeMap<String, String> requestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                for (String headerName : Collections.list(headerNames)) {
                    requestHeaders.put(headerName, request.getHeader(headerName));
                }
                this.dwEaiFasyncTaskService.insertFasyncTask(digiReqId, tenantId, requestHeaders, messageBody);
            }
            catch (Exception e) {
                log.error((Object)"insert fasync task error", (Throwable)e);
            }
        }
    }

    private void updateFasyncTask(String digiReqId, DWEAIFasyncResult fasyncResult) {
        if (this.enableFasyncTaskPool(fasyncResult) && this.enableFasyncTaskPoolPersistence()) {
            try {
                this.dwEaiFasyncTaskService.updateFasyncTask(digiReqId);
            }
            catch (Exception e) {
                log.error((Object)"update fasync task error", (Throwable)e);
            }
        }
    }

    private void deleteFasyncTask(String digiReqId, DWEAIFasyncResult fasyncResult) {
        if (this.enableFasyncTaskPool(fasyncResult) && this.enableFasyncTaskPoolPersistence()) {
            try {
                this.dwEaiFasyncTaskService.deleteFasyncTask(digiReqId);
            }
            catch (Exception e) {
                log.error((Object)"delete fasync task error", (Throwable)e);
            }
        }
    }

    private boolean enableFasyncTaskPoolPersistence() {
        String eaiFasnycTaskPoolPersistenceEnable = this.environment.getProperty("dap.eai.fasync-task-pool.persistence.enable", "false");
        return "true".equalsIgnoreCase(eaiFasnycTaskPoolPersistenceEnable);
    }

    private void shutDownFasyncTaskExecutorService(ExecutorService executorService, DWEAIFasyncResult fasyncResult) {
        if (!this.properties.getFasyncTaskPoolEnable() && !fasyncResult.isFasyncRateLimit() && executorService != null) {
            executorService.shutdown();
        }
    }

    public Map<String, Object> getFasyncTaskExecutorServiceInfo() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("FasyncTaskExecutorServiceThreads", this.properties.getFasyncTaskExecutorServiceThreads());
        result.put("FasyncTaskExecutorServiceThreadNamePrefix", this.properties.getFasyncTaskExecutorServiceThreadNamePrefix());
        if (this.fasyncTaskExecutorService != null) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.fasyncTaskExecutorService;
            int currentCorePoolSize = threadPoolExecutor.getCorePoolSize();
            int currentMaxPoolSize = threadPoolExecutor.getCorePoolSize();
            int currentActiveCount = threadPoolExecutor.getActiveCount();
            int currentPoolSize = threadPoolExecutor.getPoolSize();
            int currentQueueSize = threadPoolExecutor.getQueue().size();
            result.put("currentCorePoolSize", currentCorePoolSize);
            result.put("currentMaxPoolSize", currentMaxPoolSize);
            result.put("currentActiveCount", currentActiveCount);
            result.put("currentPoolSize", currentPoolSize);
            result.put("currentQueueSize", currentQueueSize);
        } else {
            result.put("fasyncTaskExecutorService", "not initial");
        }
        HashMap fasyncTaskExecutorServiceMapInfo = new HashMap();
        for (Map.Entry<String, ExecutorService> fasyncTaskExecutorServiceEntry : this.fasyncTaskExecutorServiceMap.entrySet()) {
            String fasyncTaskExecutorServiceEntryKey = fasyncTaskExecutorServiceEntry.getKey();
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)fasyncTaskExecutorServiceEntry.getValue();
            HashMap<String, Integer> fasyncTaskExecutorServiceMapPoolInfo = new HashMap<String, Integer>();
            int currentCorePoolSize = threadPoolExecutor.getCorePoolSize();
            int currentMaxPoolSize = threadPoolExecutor.getCorePoolSize();
            int currentActiveCount = threadPoolExecutor.getActiveCount();
            int currentPoolSize = threadPoolExecutor.getPoolSize();
            int currentQueueSize = threadPoolExecutor.getQueue().size();
            fasyncTaskExecutorServiceMapPoolInfo.put("currentCorePoolSize", currentCorePoolSize);
            fasyncTaskExecutorServiceMapPoolInfo.put("currentMaxPoolSize", currentMaxPoolSize);
            fasyncTaskExecutorServiceMapPoolInfo.put("currentActiveCount", currentActiveCount);
            fasyncTaskExecutorServiceMapPoolInfo.put("currentPoolSize", currentPoolSize);
            fasyncTaskExecutorServiceMapPoolInfo.put("currentQueueSize", currentQueueSize);
            fasyncTaskExecutorServiceMapInfo.put(fasyncTaskExecutorServiceEntryKey, fasyncTaskExecutorServiceMapPoolInfo);
        }
        result.put("fasyncTaskExecutorServiceMap", fasyncTaskExecutorServiceMapInfo);
        if (this.dwEaiFasyncTaskService != null) {
            List waitingFasyncTasks = this.dwEaiFasyncTaskService.getWaitingFasyncTasks();
            result.put("waitingFasyncTasks", waitingFasyncTasks);
        }
        if (this.dwEaiServiceInstanceService != null) {
            List serviceInstances = this.dwEaiServiceInstanceService.getServiceInstances();
            result.put("serviceInstance", serviceInstances);
        }
        return result;
    }

    public void cleanFasyncTaskExecutorServiceMap() {
        for (Map.Entry<String, ExecutorService> fasyncTaskExecutorServiceEntry : this.fasyncTaskExecutorServiceMap.entrySet()) {
            fasyncTaskExecutorServiceEntry.getValue().shutdown();
        }
        this.fasyncTaskExecutorServiceMap.clear();
        this.fasyncTaskExecutorServiceInitialMap.clear();
    }

    private MongoCollection<Document> getFilesCollection(String reqid) {
        return this.getCollection("files", reqid);
    }

    private MongoCollection<Document> getChunksCollection(String reqid) {
        return this.getCollection("chunks", reqid);
    }

    private MongoCollection<Document> getCollection(String reqid) {
        return this.getCollection("", reqid);
    }

    private MongoCollection<Document> getCollection(String collectionName, String reqid) {
        MongoCollection collection;
        Object first = String.valueOf(reqid.charAt(0));
        if (!collectionName.isEmpty()) {
            first = (String)first + "." + collectionName;
        }
        MongoDatabase database = this.getMongoDatabase();
        long expireAfter = this.getExpireAfter();
        List collectionNameList = (List)database.listCollectionNames().into(new ArrayList());
        IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(expireAfter), TimeUnit.MILLISECONDS);
        if (!collectionNameList.contains(first)) {
            database.createCollection((String)first);
            collection = database.getCollection((String)first);
            collection.createIndex((Bson)new Document("expireAt", (Object)1), indexOptions);
        }
        collection = database.getCollection((String)first);
        return collection;
    }

    private MongoDatabase getMongoDatabase() {
        String databaseName = this.environment.getProperty("fasyncMongoDatabaseName");
        MongoDatabase database = this.mongoClient.getDatabase(databaseName);
        return database;
    }

    private long getExpireAfter() {
        String expireAfterString = this.environment.getProperty("fasyncMongoExpireAfter", "14");
        long expireAfter = Long.valueOf(expireAfterString) * 24L * 60L * 60L * 1000L;
        return expireAfter;
    }

    private GridFSBucket getGridFSBucket(String reqid) {
        String first = String.valueOf(reqid.charAt(0));
        MongoDatabase database = this.getMongoDatabase();
        GridFSBucket gridFSBucket = GridFSBuckets.create((MongoDatabase)database, (String)first);
        return gridFSBucket;
    }

    private boolean reqIdExit(String reqId) {
        MongoCollection<Document> collection;
        long count;
        return this.mongoClient != null && (count = (collection = this.getCollection(reqId)).countDocuments(Filters.eq((String)"key", (Object)(CHAIN_PARAMETER_PREFIX + reqId)))) > 0L;
    }

    public void onApplicationEvent(InstanceRegisteredEvent event) {
        if (this.eaiCallbackArarmService != null) {
            this.eaiCallbackArarmService.startArarm(o -> {
                String reqId = o.getReqId();
                return (this.redis == null || this.redis.hasKey((Object)(CHAIN_PARAMETER_PREFIX + reqId)) == false) && (this.mongoClient == null || !this.reqIdExit(reqId));
            });
        }
    }
}

