/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.filter;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceLocationInfo;
import com.digiwin.app.service.eai.DWEAIServiceLocationInfo;
import com.digiwin.gateway.filter.DWEaiServiceMethodLocateFilter;
import com.digiwin.gateway.filter.DWFilterUtils;
import com.digiwin.gateway.filter.exceptions.DWEaiMethodNotFoundException;
import com.digiwin.gateway.http.DWRequestWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class DWEaiCallbackMethodLocateFilter
implements Filter {
    private DWContainerContext containerContext;

    public DWEaiCallbackMethodLocateFilter(DWContainerContext containerContext) {
        this.containerContext = containerContext;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DWServiceContext.getContext().remove();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String callback = httpRequest.getHeader("digi-callback-callback");
        DWEAIServiceLocationInfo locationInfo = new DWEAIServiceLocationInfo(callback, true);
        DWTargetAPI api = this.containerContext.getAPI((DWServiceLocationInfo)locationInfo);
        if (!DWTargetAPI.isValid((DWTargetAPI)api)) {
            DWEaiMethodNotFoundException e = new DWEaiMethodNotFoundException(callback);
            DWFilterUtils.failResponse((Exception)((Object)e), httpResponse);
            return;
        }
        String token = httpRequest.getHeader("digi-callback-token");
        DWRequestWrapper requestWrapper = new DWRequestWrapper(this, (ServletRequest)httpRequest){
            private String token;

            public String getHeader(String name) {
                String value;
                if ("token".equals(name) && (value = this.token) != null) {
                    return value;
                }
                return super.getHeader(name);
            }

            private DWRequestWrapper setToken(String token) {
                this.token = token;
                return this;
            }
        }.setToken(token);
        DWDefaultParameters parameters = DWEaiServiceMethodLocateFilter.getDWParameters(requestWrapper);
        httpRequest.setAttribute("targetAPI", (Object)api);
        httpRequest.setAttribute("targetParameters", (Object)parameters);
        httpRequest.setAttribute("targetServiceId", (Object)String.format("eai-callback@%s", locationInfo.getEAIServiceId()));
        chain.doFilter((ServletRequest)requestWrapper, response);
    }

    public void destroy() {
    }
}

