/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.condition;

import com.digiwin.app.autoconfigure.condition.DWScheduleEnableCondition;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class MultiScheduleModeCondition
implements Condition {
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        Environment environment = conditionContext.getEnvironment();
        boolean multiScheduleMode = MultiScheduleModeCondition.isMultiScheduleMode(environment);
        boolean scheduleEnable = DWScheduleEnableCondition.isScheduleEnabled(conditionContext.getEnvironment());
        return scheduleEnable && multiScheduleMode;
    }

    public static boolean isMultiScheduleMode(Environment environment) {
        String multiDataSources = environment.getProperty("org.quartz.jobStore.multiDataSources", "");
        return !"@org.quartz.jobStore.multiDataSources@".equals(multiDataSources) && !StringUtils.isBlank((CharSequence)multiDataSources);
    }
}

