/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.condition;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DapMultipleAppEnvCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return DapMultipleAppEnvCondition.isMultipleAppEnv(context.getEnvironment());
    }

    public static boolean isMultipleAppEnv(Environment environment) {
        String multipleAppEnv = environment.getProperty("dap.multiple-app-env", "false");
        return StringUtils.isNotBlank((CharSequence)multipleAppEnv) && !multipleAppEnv.matches("^@.*@$");
    }
}

