/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.config;

import com.digiwin.config.DWDefaultTenantServiceConfig;
import com.digiwin.config.TenantServiceConfig;
import com.digiwin.factory.DAPInstanceChooser;
import com.digiwin.loadbalance.DWTenantServiceInstanceChooser;
import com.digiwin.region.DAPServerVersionPredicateFactory;
import com.digiwin.region.DAPStatemodePredicateFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DWClientLoadBlanceConfigure {
    @Bean
    TenantServiceConfig defaultTenantServiceConfig(Environment environment) {
        String serviceName = environment.getProperty("loadbalancer.client.name");
        return new DWDefaultTenantServiceConfig(serviceName);
    }

    @Bean
    @ConditionalOnMissingBean
    DAPServerVersionPredicateFactory serverVersionPredicateFactory(Environment environment) {
        String serviceName = environment.getProperty("loadbalancer.client.name");
        return new DAPServerVersionPredicateFactory(serviceName);
    }

    @Bean
    @ConditionalOnMissingBean
    DAPStatemodePredicateFactory statemodePredicateFactory(Environment environment) {
        String serviceName = environment.getProperty("loadbalancer.client.name");
        return new DAPStatemodePredicateFactory(serviceName);
    }

    @Bean
    @ConditionalOnMissingBean
    DAPInstanceChooser dapInstanceChooser(Environment environment, DiscoveryClient discoveryClient, DAPServerVersionPredicateFactory dapServerVersionPredicateFactory, DAPStatemodePredicateFactory dapStatemodePredicateFactory) {
        String serviceName = environment.getProperty("loadbalancer.client.name");
        return new DWTenantServiceInstanceChooser(discoveryClient, serviceName, dapStatemodePredicateFactory, dapServerVersionPredicateFactory);
    }
}

