/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.config;

import com.digiwin.properties.auth.DAPAuthenProperties;
import com.digiwin.robbin.DAPCachingSpringLoadBalancerFactory;
import com.digiwin.robbin.tenant.DAPFeignRouteFlagService;
import com.digiwin.robbin.tenant.DAPRouteFlagService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.FeignRibbonClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfigureBefore(value={FeignRibbonClientAutoConfiguration.class})
@AutoConfigureAfter(value={RibbonAutoConfiguration.class})
public class FactoryAutoConfiguration {
    @Bean
    DAPAuthenProperties dapAuthenProperties() {
        return new DAPAuthenProperties();
    }

    @Bean
    DAPRouteFlagService dapRouteFlagService(DAPAuthenProperties dapAuthenProperties) {
        return new DAPFeignRouteFlagService(dapAuthenProperties);
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.retry.support.RetryTemplate"})
    public CachingSpringLoadBalancerFactory cachingLBClientFactory(SpringClientFactory factory, DAPRouteFlagService dapRouteFlagService) {
        return new DAPCachingSpringLoadBalancerFactory(factory, dapRouteFlagService);
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.retry.support.RetryTemplate"})
    public CachingSpringLoadBalancerFactory retryabeCachingLBClientFactory(SpringClientFactory factory, LoadBalancedRetryFactory retryFactory, DAPRouteFlagService dapRouteFlagService) {
        return new DAPCachingSpringLoadBalancerFactory(factory, retryFactory, dapRouteFlagService);
    }
}

