/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.factory;

import com.digiwin.config.DWClientLoadBlanceConfigure;
import com.digiwin.factory.DAPClientFactory;
import com.digiwin.factory.DAPInstanceChooser;
import com.digiwin.factory.LoadBalancerClientSpecification;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.context.named.NamedContextFactory;
import org.springframework.core.env.Environment;

public class DAPLoadBalancerClientFactory
extends NamedContextFactory<LoadBalancerClientSpecification>
implements DAPClientFactory {
    public static final String NAMESPACE = "loadbalancer";
    public static final String PROPERTY_NAME = "loadbalancer.client.name";

    public DAPLoadBalancerClientFactory() {
        this(DWClientLoadBlanceConfigure.class, NAMESPACE, PROPERTY_NAME);
    }

    public DAPLoadBalancerClientFactory(Class configureCalss, String nameSpace, String propertyName) {
        super(configureCalss, nameSpace, propertyName);
    }

    public String getName(Environment environment) {
        return environment.getProperty(PROPERTY_NAME);
    }

    @Override
    public DAPInstanceChooser getInstanceChooser(String service) {
        return (DAPInstanceChooser)this.getInstance(service, DAPInstanceChooser.class);
    }

    @Override
    public ServiceInstance chooseInstance(String service, String tenantId) {
        return ((DAPInstanceChooser)this.getInstance(service, DAPInstanceChooser.class)).choose(tenantId);
    }
}

