/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.region;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.digiwin.region.DAPInstancePredicateFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.springframework.cloud.client.ServiceInstance;

public class DAPServerVersionPredicateFactory
implements DAPInstancePredicateFactory<ServiceInstance, String> {
    private final String Tenant_Version_Sufix = "tv";
    private final String serviceNameSpace;
    public Map<String, String> tenantVersionMap = new ConcurrentHashMap<String, String>();

    @Override
    public Predicate<ServiceInstance> getPredicate(String tenantId) {
        String serviceVersion = this.getServiceVersion(tenantId);
        return seviceInstance -> ((String)seviceInstance.getMetadata().get("version")).equals(serviceVersion);
    }

    public DAPServerVersionPredicateFactory(String serviceName) {
        this.serviceNameSpace = serviceName + "_" + "tv";
        Config config = ConfigService.getConfig((String)this.serviceNameSpace);
        this.fillTenantVersion(config);
        config.addChangeListener(changeEvent -> {
            this.tenantVersionMap.clear();
            this.fillTenantVersion(config);
        });
    }

    public void fillTenantVersion(Config config) {
        config.getPropertyNames().stream().forEach(version -> {
            String property = config.getProperty(version, null);
            if (Objects.nonNull(property)) {
                Arrays.stream(property.split(",")).forEach(tentId -> this.tenantVersionMap.put((String)tentId, (String)version));
            }
        });
    }

    public String getServiceVersion(String tenantId) {
        if (StringUtils.isEmpty((String)tenantId) || !this.tenantVersionMap.containsKey(tenantId)) {
            return "default";
        }
        return this.tenantVersionMap.get(tenantId);
    }
}

