/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.region;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.digiwin.region.DAPInstancePredicateFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;

public class DAPStatemodePredicateFactory
implements ConfigChangeListener,
DAPInstancePredicateFactory<ServiceInstance, String> {
    public static final String CONFIG_SPILIT = "_";
    public static final String APOLLO_FILE_NAME_SPLIT = "_";
    public static final String ACTIVE_REGION_SUFIX = "ar";
    public static final String TENANT_REGION_SUFIX = "tr";
    private static Log log = LogFactory.getLog(DAPStatemodePredicateFactory.class);
    private final String serviceName;
    private static String NULL_TENANTID = "NULL@@TENANTID";
    private Map<String, Map<String, String>> preMap = new ConcurrentHashMap<String, Map<String, String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DAPStatemodePredicateFactory(String serviceName) {
        this.serviceName = serviceName;
        String ar = serviceName + "_" + ACTIVE_REGION_SUFIX;
        Config config = ConfigService.getConfig((String)ar);
        config.addChangeListener((ConfigChangeListener)this);
        Map<String, Map<String, String>> map = this.preMap;
        synchronized (map) {
            this.loadRouteMap();
        }
    }

    public Predicate<ServiceInstance> getRegionPredicate(String tenantId) {
        return seviceInstance -> {
            String instanceIamge = (String)seviceInstance.getMetadata().get("APPIMAGENAME");
            String instanceRegion = (String)seviceInstance.getMetadata().get("STATEMODE");
            if (StringUtils.isBlank((CharSequence)instanceIamge)) {
                return true;
            }
            String arNameSpace = this.serviceName + "_" + ACTIVE_REGION_SUFIX;
            Config arConfig = ConfigService.getConfig((String)arNameSpace);
            String target_region = null;
            target_region = this.getTargetRegion(instanceIamge, tenantId);
            return StringUtils.isBlank((CharSequence)target_region) ? arConfig.getProperty(instanceIamge, "").equals(instanceRegion) : instanceRegion.equals(target_region);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(ConfigChangeEvent configChangeEvent) {
        Map<String, Map<String, String>> map = this.preMap;
        synchronized (map) {
            this.loadRouteMap();
        }
    }

    public void loadRouteMap() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, String>> newMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, String>>();
        Config arConfig = ConfigService.getConfig((String)(this.serviceName + "_" + ACTIVE_REGION_SUFIX));
        Set imageNames = arConfig.getPropertyNames();
        for (String string : imageNames) {
            String imagedTrName = this.serviceName + "_" + string + "_" + TENANT_REGION_SUFIX;
            Config imagedTrConfig = ConfigService.getConfig((String)imagedTrName);
            imagedTrConfig.addChangeListener((ConfigChangeListener)this);
            String activeRegion = arConfig.getProperty(string, "");
            if (StringUtils.isBlank((CharSequence)activeRegion)) continue;
            List preRegions = imagedTrConfig.getPropertyNames().stream().filter(regionName -> !activeRegion.equals(regionName)).collect(Collectors.toList());
            for (String preRegion : preRegions) {
                String[] preTentantIds;
                for (String preTentantId : preTentantIds = imagedTrConfig.getArrayProperty(preRegion, ",", new String[0])) {
                    if (StringUtils.isBlank((CharSequence)preTentantId)) continue;
                    ConcurrentHashMap<String, String> imageMapPreRegion = (ConcurrentHashMap<String, String>)newMap.get(preTentantId);
                    if (null == imageMapPreRegion) {
                        imageMapPreRegion = new ConcurrentHashMap<String, String>();
                        newMap.put(preTentantId, imageMapPreRegion);
                    }
                    imageMapPreRegion.put(string, preRegion);
                }
            }
        }
        for (Map.Entry entry : this.preMap.entrySet()) {
            if (newMap.containsKey(entry.getKey())) continue;
            this.preMap.remove(entry.getKey());
        }
        for (Map.Entry entry : newMap.entrySet()) {
            this.preMap.put((String)entry.getKey(), (Map<String, String>)entry.getValue());
        }
    }

    String getTargetRegion(String imageName, String tenantId) {
        String targetRegion = (String)((Map)this.preMap.getOrDefault(tenantId, new HashMap())).get(imageName);
        return targetRegion;
    }

    @Override
    public Predicate<ServiceInstance> getPredicate(String tenantId) {
        return this.getRegionPredicate(StringUtils.isBlank((CharSequence)tenantId) ? NULL_TENANTID : tenantId);
    }
}

