/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.region;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.digiwin.region.RegionSwitch;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.context.ApplicationContext;

public class DefaultRegionSwitch
implements RegionSwitch,
ConfigChangeListener {
    private static Log log = LogFactory.getLog(DefaultRegionSwitch.class);
    ApplicationContext applicationContext;
    private String serviceName;
    private static String NULL_TENANTID = "NULL@@TENANTID";
    public static final String CONFIG_SPILIT = "_";
    public static final String ACTIVE_REGION_SUFIX = "ar";
    public static final String TENANT_REGION_SUFIX = "tr";
    private Map<String, Map<String, String>> preMap = new ConcurrentHashMap<String, Map<String, String>>();

    public DefaultRegionSwitch(String serviceName, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.serviceName = serviceName;
        String ar = serviceName + CONFIG_SPILIT + ACTIVE_REGION_SUFIX;
        Config config = ConfigService.getConfig((String)ar);
        config.addChangeListener((ConfigChangeListener)this);
        this.loadRouteMap();
    }

    @Override
    public Optional<Predicate<? super ServiceInstance>> getRegionPredicate(String tenantId) {
        return this.getPredicate(StringUtils.isBlank((CharSequence)tenantId) ? NULL_TENANTID : tenantId);
    }

    private Optional<Predicate<? super ServiceInstance>> getPredicate(String tenantId) {
        return Optional.of(seviceInstance -> false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(ConfigChangeEvent changeEvent) {
        Map<String, Map<String, String>> map = this.preMap;
        synchronized (map) {
            this.loadRouteMap();
        }
    }

    public void loadRouteMap() {
    }

    String getTargetRegion(String imageName, String tenantId) {
        String targetRegion = (String)((Map)this.preMap.getOrDefault(tenantId, new HashMap())).get(imageName);
        return targetRegion;
    }
}

