/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.robbin;

import com.digiwin.robbin.DAPRetryableFeignLoadBalancer;
import com.digiwin.robbin.DapLoadBalancer;
import com.digiwin.robbin.tenant.DAPRouteFlagService;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import java.util.Map;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.FeignLoadBalancer;
import org.springframework.util.ConcurrentReferenceHashMap;

public class DAPCachingSpringLoadBalancerFactory
extends CachingSpringLoadBalancerFactory {
    private final DAPRouteFlagService dapRouteFlagService;
    private final SpringClientFactory factory;
    private LoadBalancedRetryFactory loadBalancedRetryFactory = null;
    private volatile Map<String, FeignLoadBalancer> cache = new ConcurrentReferenceHashMap();

    public DAPCachingSpringLoadBalancerFactory(SpringClientFactory factory, DAPRouteFlagService dapRouteFlagService) {
        super(factory);
        this.factory = factory;
        this.dapRouteFlagService = dapRouteFlagService;
    }

    public DAPCachingSpringLoadBalancerFactory(SpringClientFactory factory, LoadBalancedRetryFactory loadBalancedRetryPolicyFactory, DAPRouteFlagService dapRouteFlagService) {
        super(factory, loadBalancedRetryPolicyFactory);
        this.factory = factory;
        this.loadBalancedRetryFactory = loadBalancedRetryPolicyFactory;
        this.dapRouteFlagService = dapRouteFlagService;
    }

    public FeignLoadBalancer create(String clientName) {
        Object client = this.cache.get(clientName);
        if (client != null) {
            return client;
        }
        IClientConfig config = this.factory.getClientConfig(clientName);
        ILoadBalancer lb = this.factory.getLoadBalancer(clientName);
        ServerIntrospector serverIntrospector = (ServerIntrospector)this.factory.getInstance(clientName, ServerIntrospector.class);
        client = this.loadBalancedRetryFactory != null ? new DAPRetryableFeignLoadBalancer(lb, config, serverIntrospector, this.loadBalancedRetryFactory, this.dapRouteFlagService) : new DapLoadBalancer(lb, config, serverIntrospector, this.dapRouteFlagService);
        this.cache.put(clientName, (FeignLoadBalancer)client);
        return client;
    }
}

