/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.robbin;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.digiwin.util.DWLoadbalanceConstant;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.PredicateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;

public class StatemodePredicate
extends AbstractServerPredicate
implements ConfigChangeListener {
    SpringClientFactory clientFactory;
    private Map<String, Map<String, String>> preMap = new ConcurrentHashMap<String, Map<String, String>>();
    private String name;

    public StatemodePredicate(String name, SpringClientFactory clientFactory) {
        this.name = name;
        this.clientFactory = clientFactory;
        this.loadRouteMap();
    }

    public StatemodePredicate(IRule rule, String name) {
        super(rule);
        this.name = name;
        this.loadRouteMap();
    }

    public StatemodePredicate(IRule rule, IClientConfig clientConfig, String name) {
        super(rule, clientConfig);
        this.name = name;
        this.loadRouteMap();
    }

    public StatemodePredicate(LoadBalancerStats lbStats, IClientConfig clientConfig, String name) {
        super(lbStats, clientConfig);
        this.name = name;
        this.loadRouteMap();
    }

    public boolean apply(@Nullable PredicateKey predicateKey) {
        ServerIntrospector serverIntrospector = (ServerIntrospector)this.clientFactory.getInstance(this.name, ServerIntrospector.class);
        Map metadata = serverIntrospector.getMetadata(predicateKey.getServer());
        String tenantId = (String)StringUtils.defaultIfBlank((CharSequence)(null != predicateKey.getLoadBalancerKey() ? predicateKey.getLoadBalancerKey().toString() : ""), (CharSequence)DWLoadbalanceConstant.NULL_TENANTID);
        String instanceIamge = (String)metadata.get("APPIMAGENAME");
        String instanceRegion = (String)metadata.get("STATEMODE");
        if (StringUtils.isBlank((CharSequence)instanceIamge) || StringUtils.isBlank((CharSequence)instanceRegion)) {
            return true;
        }
        String arNameSpace = this.name + "_" + "ar";
        Config arConfig = ConfigService.getConfig((String)arNameSpace);
        String target_region = null;
        target_region = this.getTargetRegion(instanceIamge, tenantId);
        return StringUtils.isBlank((CharSequence)target_region) ? arConfig.getProperty(instanceIamge, "").equals(instanceRegion) : instanceRegion.equals(target_region);
    }

    public void loadRouteMap() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, String>> newMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, String>>();
        Config arConfig = ConfigService.getConfig((String)(this.name + "_" + "ar"));
        arConfig.addChangeListener((ConfigChangeListener)this);
        Set imageNames = arConfig.getPropertyNames();
        for (String string : imageNames) {
            String imagedTrName = this.name + "_" + string + "_" + "tr";
            Config imagedTrConfig = ConfigService.getConfig((String)imagedTrName);
            imagedTrConfig.addChangeListener((ConfigChangeListener)this);
            String activeRegion = arConfig.getProperty(string, "");
            if (StringUtils.isBlank((CharSequence)activeRegion)) continue;
            List preRegions = imagedTrConfig.getPropertyNames().stream().filter(regionName -> !activeRegion.equals(regionName)).collect(Collectors.toList());
            for (String preRegion : preRegions) {
                String[] preTentantIds;
                for (String preTentantId : preTentantIds = imagedTrConfig.getArrayProperty(preRegion, ",", new String[0])) {
                    if (StringUtils.isBlank((CharSequence)preTentantId)) continue;
                    ConcurrentHashMap<String, String> imageMapPreRegion = (ConcurrentHashMap<String, String>)newMap.get(preTentantId);
                    if (null == imageMapPreRegion) {
                        imageMapPreRegion = new ConcurrentHashMap<String, String>();
                        newMap.put(preTentantId, imageMapPreRegion);
                    }
                    imageMapPreRegion.put(string, preRegion);
                }
            }
        }
        for (Map.Entry entry : this.preMap.entrySet()) {
            if (newMap.containsKey(entry.getKey())) continue;
            this.preMap.remove(entry.getKey());
        }
        for (Map.Entry entry : newMap.entrySet()) {
            this.preMap.put((String)entry.getKey(), (Map<String, String>)entry.getValue());
        }
    }

    String getTargetRegion(String imageName, String tenantId) {
        String targetRegion = (String)((Map)this.preMap.getOrDefault(tenantId, new HashMap())).get(imageName);
        return targetRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(ConfigChangeEvent configChangeEvent) {
        Map<String, Map<String, String>> map = this.preMap;
        synchronized (map) {
            this.loadRouteMap();
        }
    }
}

