/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.robbin;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.digiwin.util.DWLoadbalanceConstant;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.LoadBalancerStats;
import com.netflix.loadbalancer.PredicateKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;

public class VersionPredicate
extends AbstractServerPredicate
implements ConfigChangeListener {
    private final String Tenant_Version_Sufix = "tv";
    public Map<String, String> tenantVersionMap = new ConcurrentHashMap<String, String>();
    private String name;
    SpringClientFactory clientFactory;

    public VersionPredicate(String name, SpringClientFactory clientFactory) {
        this.name = name;
        this.clientFactory = clientFactory;
        this.loadRouteMap();
    }

    public VersionPredicate(IRule rule, String name) {
        super(rule);
        this.name = name;
        this.loadRouteMap();
    }

    public VersionPredicate(IRule rule, IClientConfig clientConfig, String name) {
        super(rule, clientConfig);
        this.name = name;
        this.loadRouteMap();
    }

    public VersionPredicate(LoadBalancerStats lbStats, IClientConfig clientConfig, String name) {
        super(lbStats, clientConfig);
        this.name = name;
        this.loadRouteMap();
    }

    public boolean apply(@Nullable PredicateKey predicateKey) {
        ServerIntrospector serverIntrospector = (ServerIntrospector)this.clientFactory.getInstance(this.name, ServerIntrospector.class);
        Map metadata = serverIntrospector.getMetadata(predicateKey.getServer());
        String tenantId = (String)StringUtils.defaultIfBlank((CharSequence)(null != predicateKey.getLoadBalancerKey() ? predicateKey.getLoadBalancerKey().toString() : ""), (CharSequence)DWLoadbalanceConstant.NULL_TENANTID);
        String serviceVersion = this.getServiceVersion(tenantId);
        String instanceVersion = (String)metadata.get("version");
        return StringUtils.isBlank((CharSequence)instanceVersion) || serviceVersion.equals(instanceVersion);
    }

    public void loadRouteMap() {
        Config config = ConfigService.getConfig((String)(this.name + "_" + "tv"));
        this.fillTenantVersion(config);
        config.addChangeListener((ConfigChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(ConfigChangeEvent configChangeEvent) {
        Map<String, String> map = this.tenantVersionMap;
        synchronized (map) {
            Config config = ConfigService.getConfig((String)(this.name + "_" + "tv"));
            this.fillTenantVersion(config);
        }
    }

    public void fillTenantVersion(Config config) {
        config.getPropertyNames().stream().forEach(version -> {
            String property = config.getProperty(version, null);
            if (Objects.nonNull(property)) {
                Arrays.stream(property.split(",")).forEach(tentId -> this.tenantVersionMap.put((String)tentId, (String)version));
            }
        });
    }

    public String getServiceVersion(String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId) || !this.tenantVersionMap.containsKey(tenantId)) {
            return "default";
        }
        return this.tenantVersionMap.get(tenantId);
    }
}

