/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.config;

import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;

public class LoadBalanceEnabelConfigure
implements ImportSelector,
EnvironmentAware {
    private static final String LOAD_BALANCE_PROPERTY_SOURCE_NAME = "digiwin.service.load.balance.enable.property";
    private Environment environment;

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        if (ConfigurableEnvironment.class.isInstance(this.environment)) {
            ConfigurableEnvironment configEnv = (ConfigurableEnvironment)this.environment;
            LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
            String dwloadBalanceEnable = configEnv.getProperty("dwloadBalanceEnable");
            if (!"true".equalsIgnoreCase(dwloadBalanceEnable)) {
                propertyMap.put("spring.cloud.discovery.enabled", "false");
                propertyMap.put("digiwin.load.balance.autoCongiguration.flage", "false");
                propertyMap.put("spring.cloud.nacos.discovery.enabled", "false");
            } else {
                propertyMap.put("spring.cloud.nacos.discovery.watchDelay", configEnv.getProperty("dwdiscoveryWatchDelay"));
                propertyMap.put("spring.cloud.nacos.discovery.server-addr", configEnv.getProperty("dwdiscoveryServer"));
                if (StringUtils.isNotBlank((CharSequence)configEnv.getProperty("dwdiscoveryUsername"))) {
                    propertyMap.put("spring.cloud.nacos.discovery.username", configEnv.getProperty("dwdiscoveryUsername"));
                }
                if (StringUtils.isNotBlank((CharSequence)configEnv.getProperty("dwdiscoveryPassword"))) {
                    propertyMap.put("spring.cloud.nacos.discovery.password", configEnv.getProperty("dwdiscoveryPassword"));
                }
                if (StringUtils.isNotBlank((CharSequence)configEnv.getProperty("dwdiscoveryNamespace"))) {
                    propertyMap.put("spring.cloud.nacos.discovery.namespace", configEnv.getProperty("dwdiscoveryNamespace"));
                }
                if (StringUtils.isNotBlank((CharSequence)configEnv.getProperty("dwdiscoveryClusterName"))) {
                    propertyMap.put("spring.cloud.nacos.discovery.clusterName", configEnv.getProperty("dwdiscoveryClusterName"));
                }
                if (StringUtils.isNotBlank((CharSequence)configEnv.getProperty("dwdiscoveryGroup"))) {
                    propertyMap.put("spring.cloud.nacos.discovery.group", configEnv.getProperty("dwdiscoveryGroup"));
                }
                propertyMap.put("spring.cloud.discovery.enabled", "true");
                propertyMap.put("digiwin.load.balance.autoCongiguration.flage", "true");
                propertyMap.put("spring.cloud.nacos.discovery.enabled", "true");
                if ("true".equalsIgnoreCase(configEnv.getProperty("dap.multiple-app-env"))) {
                    propertyMap.put("spring.cloud.discovery.enabled", "false");
                    propertyMap.put("spring.cloud.nacos.discovery.enabled", "false");
                }
            }
            MapPropertySource propertySource = new MapPropertySource(LOAD_BALANCE_PROPERTY_SOURCE_NAME, propertyMap);
            configEnv.getPropertySources().addFirst((PropertySource)propertySource);
        }
        return new String[0];
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

