/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.loadbalance;

import com.digiwin.factory.DAPInstanceChooser;
import com.digiwin.region.DAPServerVersionPredicateFactory;
import com.digiwin.region.DAPStatemodePredicateFactory;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class DWTenantServiceInstanceChooser
implements DAPInstanceChooser {
    private final String serviceName;
    private final DiscoveryClient discoveryClient;
    AtomicInteger position = new AtomicInteger(new Random().nextInt(1000));
    private final DAPStatemodePredicateFactory statemodePredicateFactory;
    private final DAPServerVersionPredicateFactory versionPredicateFactory;

    public DWTenantServiceInstanceChooser(DiscoveryClient discoveryClient, String serviceName, DAPStatemodePredicateFactory statemodePredicateFactory, DAPServerVersionPredicateFactory versionPredicateFactory) {
        this.serviceName = serviceName;
        this.discoveryClient = discoveryClient;
        this.statemodePredicateFactory = statemodePredicateFactory;
        this.versionPredicateFactory = versionPredicateFactory;
    }

    public ServiceInstance choose(String loadKey) {
        List instances = this.discoveryClient.getInstances(this.serviceName);
        List<ServiceInstance> serviceInstances = instances.stream().filter(this.versionPredicateFactory.getPredicate(loadKey)).filter(this.statemodePredicateFactory.getPredicate(loadKey)).collect(Collectors.toList());
        return this.selectInstance(serviceInstances);
    }

    private ServiceInstance selectInstance(List<ServiceInstance> serviceInstanceList) {
        if (CollectionUtils.isEmpty(serviceInstanceList)) {
            return null;
        }
        int pos = this.position.incrementAndGet() & Integer.MAX_VALUE;
        return serviceInstanceList.get(pos % serviceInstanceList.size());
    }
}

