/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.robbin;

import com.digiwin.robbin.tenant.DAPRouteFlagService;
import com.netflix.client.ClientException;
import com.netflix.client.ClientRequest;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.LoadBalancerContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import com.netflix.loadbalancer.reactive.ServerOperation;
import feign.Request;
import java.lang.reflect.Field;
import java.net.URI;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.openfeign.ribbon.FeignLoadBalancer;
import rx.Observable;

public class DapLoadBalancer
extends FeignLoadBalancer {
    private final DAPRouteFlagService dapRouteFlagService;

    public DapLoadBalancer(ILoadBalancer lb, IClientConfig clientConfig, ServerIntrospector serverIntrospector, DAPRouteFlagService dapRouteFlagService) {
        super(lb, clientConfig, serverIntrospector);
        this.dapRouteFlagService = dapRouteFlagService;
    }

    private Request getOriginalRequest(FeignLoadBalancer.RibbonRequest request) {
        Request oRequest = null;
        try {
            Field requestField = request.getClass().getDeclaredField("request");
            requestField.setAccessible(true);
            oRequest = (Request)requestField.get(request);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return oRequest;
    }

    public FeignLoadBalancer.RibbonResponse executeWithLoadBalancer(final FeignLoadBalancer.RibbonRequest request, final IClientConfig config) throws ClientException {
        RequestSpecificRetryHandler handler = this.getRequestSpecificRetryHandler(request, config);
        LoadBalancerCommand.Builder builder = LoadBalancerCommand.builder().withLoadBalancerContext((LoadBalancerContext)this).withRetryHandler((RetryHandler)handler).withLoadBalancerURI(request.getUri());
        this.customizeLoadBalancerCommandBuilder((ClientRequest)request, config, builder);
        Request originalRequest = this.getOriginalRequest(request);
        String tentantId = this.getTentantId(originalRequest);
        builder.withServerLocator((Object)tentantId);
        LoadBalancerCommand command = builder.build();
        try {
            return (FeignLoadBalancer.RibbonResponse)command.submit((ServerOperation)new ServerOperation<FeignLoadBalancer.RibbonResponse>(){

                public Observable<FeignLoadBalancer.RibbonResponse> call(Server server) {
                    URI finalUri = DapLoadBalancer.this.reconstructURIWithServer(server, request.getUri());
                    FeignLoadBalancer.RibbonRequest requestForServer = (FeignLoadBalancer.RibbonRequest)request.replaceUri(finalUri);
                    try {
                        return Observable.just((Object)DapLoadBalancer.this.execute(requestForServer, config));
                    }
                    catch (Exception e) {
                        return Observable.error((Throwable)e);
                    }
                }
            }).toBlocking().single();
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof ClientException) {
                throw (ClientException)t;
            }
            throw new ClientException((Throwable)e);
        }
    }

    private String getTentantId(Request request) {
        return this.dapRouteFlagService.getTenantId(request);
    }
}

