/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.region;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;

public class VersionPredicate
implements Predicate<ServiceInstance>,
ConfigChangeListener {
    private static final String TENANT_VERSION_SUFIX = "tv";
    public Map<String, String> tenantVersionMap = new ConcurrentHashMap<String, String>();
    private final String serviceName;

    public VersionPredicate(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public boolean test(ServiceInstance serviceInstance) {
        return false;
    }

    public void loadRouteMap() {
        Config config = ConfigService.getConfig((String)(this.serviceName + "_" + TENANT_VERSION_SUFIX));
        this.fillTenantVersion(config);
        config.addChangeListener((ConfigChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(ConfigChangeEvent configChangeEvent) {
        Map<String, String> map = this.tenantVersionMap;
        synchronized (map) {
            Config config = ConfigService.getConfig((String)(this.serviceName + "_" + TENANT_VERSION_SUFIX));
            this.fillTenantVersion(config);
        }
    }

    public void fillTenantVersion(Config config) {
        config.getPropertyNames().stream().forEach(version -> {
            String property = config.getProperty(version, null);
            if (Objects.nonNull(property)) {
                Arrays.stream(property.split(",")).forEach(tentId -> this.tenantVersionMap.put((String)tentId, (String)version));
            }
        });
    }

    public String getServiceVersion(String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId) || !this.tenantVersionMap.containsKey(tenantId)) {
            return "default";
        }
        return this.tenantVersionMap.get(tenantId);
    }
}

