/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.robbin;

import com.digiwin.robbin.StatemodePredicate;
import com.digiwin.robbin.VersionPredicate;
import com.digiwin.util.DWLoadbalanceConstant;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.CompositePredicate;
import com.netflix.loadbalancer.PredicateBasedRule;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;

public class DAPRule
extends PredicateBasedRule {
    private String clientName;
    private AbstractServerPredicate dapPredicate;
    ServerIntrospector serverIntrospector;

    public AbstractServerPredicate getPredicate() {
        return this.dapPredicate;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientName = clientConfig.getClientName();
        AbstractServerPredicate[] customePredicates = (AbstractServerPredicate[])clientConfig.get(DWLoadbalanceConstant.CUSTOMECONFIGKEY);
        SpringClientFactory springClientFactory = (SpringClientFactory)clientConfig.get(DWLoadbalanceConstant.RIBBONCLIENTFACTORY);
        if (customePredicates != null && customePredicates.length > 0) {
            this.dapPredicate = CompositePredicate.withPredicates((AbstractServerPredicate[])customePredicates).build();
        } else {
            StatemodePredicate statemodePredicate = new StatemodePredicate(this.clientName, springClientFactory);
            VersionPredicate versionPredicate = new VersionPredicate(this.clientName, springClientFactory);
            this.dapPredicate = CompositePredicate.withPredicates((AbstractServerPredicate[])new AbstractServerPredicate[]{statemodePredicate, versionPredicate}).build();
        }
        super.initWithNiwsConfig(clientConfig);
    }
}

