/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.robbin.tenant;

import com.digiwin.properties.auth.DAPAuthenProperties;
import com.digiwin.robbin.tenant.DAPRouteFlagService;
import com.digiwin.robbin.tenant.TenantIdService;
import feign.Request;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DAPFeignRouteFlagService
implements DAPRouteFlagService<Request> {
    @Autowired(required=false)
    TenantIdService tenantIdService;
    private final DAPAuthenProperties dapAuthenProperties;

    public DAPFeignRouteFlagService(DAPAuthenProperties dapAuthenProperties) {
        this.dapAuthenProperties = dapAuthenProperties;
    }

    public DAPFeignRouteFlagService(DAPAuthenProperties dapAuthenProperties, TenantIdService tenantIdService) {
        this.dapAuthenProperties = dapAuthenProperties;
        this.tenantIdService = tenantIdService;
    }

    @Override
    public String getTenantId(Request request) {
        Map headers = request.headers();
        String routeKey = this.getFromRouteKey(headers);
        if (StringUtils.isNotBlank((CharSequence)routeKey)) {
            return routeKey;
        }
        return this.getFromToken(headers);
    }

    private String getFromRouteKey(Map<String, Collection<String>> headers) {
        List<String> routeKeyNamesList = this.dapAuthenProperties.getRouteKeyNamesList();
        for (String keyName : routeKeyNamesList) {
            Collection<String> headerValues = headers.get(keyName);
            if (CollectionUtils.isEmpty(headerValues)) continue;
            Iterator<String> iterator = headerValues.iterator();
            return iterator.next();
        }
        return "";
    }

    private String getFromToken(Map<String, Collection<String>> headers) {
        if (this.tenantIdService != null) {
            List<String> tokenNamesList = this.dapAuthenProperties.getTokenNamesList();
            for (String keyName : tokenNamesList) {
                Collection<String> headerValues = headers.get(keyName);
                if (CollectionUtils.isEmpty(headerValues)) continue;
                Iterator<String> iterator = headerValues.iterator();
                String token = iterator.next();
                try {
                    return this.tenantIdService.getTenantId(token);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return "";
    }
}

