package com.digiwin.dap.middle.cloud.exception;

import cn.hutool.core.util.IdUtil;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorType;
import com.digiwin.dap.middleware.exception.DapExceptionOrderEnum;
import com.digiwin.dap.middleware.exception.DapLog;
import com.digiwin.dap.middleware.exception.StdError;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;

/**
 * 全局异常捕获
 *
 * @author fobgochod
 * @date 2020/6/7
 */
@RestControllerAdvice
public class DapCloudExceptionHandler implements Ordered {

    private static final Logger logger = LoggerFactory.getLogger(DapCloudExceptionHandler.class);

    @Autowired
    private DapEnv dapEnv;

    @ResponseStatus(HttpStatus.TOO_MANY_REQUESTS)
    @ExceptionHandler(RequestNotPermitted.class)
    public StdError dapBase(HttpServletRequest req, RequestNotPermitted e) {
        String expId = IdUtil.simpleUUID();
        logger.error(DapLog.of(e.getMessage(),expId, req).toString());

        StdError stdError = StdError.of(dapEnv.getAppName().toUpperCase(), ErrorType.System.name(),
                CommonErrorCode.TOO_MANY_REQUESTS, req.getRequestURI());
        stdError.setCode(HttpStatus.TOO_MANY_REQUESTS.value());
        stdError.setMessage(e.getMessage());
        stdError.setExpId(expId);
        return stdError;
    }

    @Override
    public int getOrder() {
        return DapExceptionOrderEnum.EXCEPTION_CLOUD.order();
    }
}
