/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.cloud.exception;

import cn.hutool.core.util.IdUtil;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.ErrorType;
import com.digiwin.dap.middleware.exception.DapExceptionOrderEnum;
import com.digiwin.dap.middleware.exception.DapLog;
import com.digiwin.dap.middleware.exception.StdError;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class DapCloudExceptionHandler
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(DapCloudExceptionHandler.class);
    @Autowired
    private DapEnv dapEnv;

    @ResponseStatus(value=HttpStatus.TOO_MANY_REQUESTS)
    @ExceptionHandler(value={RequestNotPermitted.class})
    public StdError dapBase(HttpServletRequest req, RequestNotPermitted e) {
        String expId = IdUtil.simpleUUID();
        logger.error(DapLog.of((String)e.getMessage(), (String)expId, (HttpServletRequest)req).toString());
        StdError stdError = StdError.of((String)this.dapEnv.getAppName().toUpperCase(), (String)ErrorType.System.name(), (ErrorHandler)CommonErrorCode.TOO_MANY_REQUESTS, (String)req.getRequestURI());
        stdError.setCode(Integer.valueOf(HttpStatus.TOO_MANY_REQUESTS.value()));
        stdError.setMessage(e.getMessage());
        stdError.setExpId(expId);
        return stdError;
    }

    public int getOrder() {
        return DapExceptionOrderEnum.EXCEPTION_CLOUD.order();
    }
}

