package com.digiwin.dap.middleware.commons.core.codec;

import com.digiwin.dap.middleware.commons.util.StrUtils;

import java.nio.charset.StandardCharsets;


/**
 * Base64工具类，提供Base64的编码和解码方案<br>
 * base64编码是用64（2的6次方）个ASCII字符来表示256（2的8次方）个ASCII字符，<br>
 * 也就是三位二进制数组经过编码后变为四位的ASCII字符显示，长度比原来增加1/3。
 *
 * @author fobgochod
 * @since 1.0.0
 */
public class Base64 {

    private Base64() {
    }

    /**
     * Base64 Encode
     *
     * @param data 要编码的字符串
     * @return 编码结果
     */
    public static String encode(String data) {
        return encode(StrUtils.bytes(data, StandardCharsets.UTF_8));
    }

    /**
     * Base64 Encode
     *
     * @param data 要编码字节数组
     * @return 编码结果
     */
    public static String encode(byte[] data) {
        return StrUtils.str(java.util.Base64.getEncoder().encode(data));
    }

    /**
     * Base64 Encode URL安全的
     *
     * @param data 要编码的字符串
     * @return 编码结果
     * @since 1.0.7
     */
    public static String encodeUrlSafe(String data) {
        return encodeUrlSafe(StrUtils.bytes(data, StandardCharsets.UTF_8));
    }

    /**
     * Base64 Encode URL安全的
     *
     * @param data 要编码字节数组
     * @return 编码结果
     * @since 1.0.7
     */
    public static String encodeUrlSafe(byte[] data) {
        return StrUtils.str(java.util.Base64.getUrlEncoder().encode(data));
    }

    /**
     * Base64  Decode
     *
     * @param data 要解码的字符串
     * @return 解码结果
     */
    public static byte[] decode(String data) {
        return decode(StrUtils.bytes(data, StandardCharsets.UTF_8));
    }

    /**
     * Base64  Decode
     * 支持
     * <a href="http://www.ietf.org/rfc/rfc4648.txt">RFC 4648</a> and
     * <a href="http://www.ietf.org/rfc/rfc2045.txt">RFC 2045</a>.
     *
     * @param data 要解码字节数组
     * @return 解码结果
     */
    public static byte[] decode(byte[] data) {
        try {
            return java.util.Base64.getMimeDecoder().decode(data);
        } catch (Exception e) {
            return java.util.Base64.getUrlDecoder().decode(data);
        }
    }
}
