package com.digiwin.dap.middleware.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 分页查询结果
 *
 * @author fobgochod
 * @since 1.0.8
 */
public class PageData<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    private long total;
    private List<T> list;

    public PageData() {
        this.list = new ArrayList<>();
    }

    public static <T> PageData<T> zero() {
        return new PageData<>();
    }

    public static <T> PageData<T> data(long total, List<T> list) {
        PageData<T> pageData = new PageData<>();
        pageData.setTotal(total);
        pageData.setList(list);
        return pageData;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}
