package com.digiwin.dap.middleware.domain;

/**
 * 标准输出
 *
 * @author fobgochod
 * @since 1.0.8
 */
public class StdData<T> {

    public static final StdData<?> OK = new StdData<>(200, "success", true);

    private int code;
    private String message;
    private T data;
    private boolean success;

    public StdData() {
    }

    public StdData(boolean success) {
        this.success = success;
    }

    public StdData(int code, String message, boolean success) {
        this.code = code;
        this.message = message;
        this.success = success;
    }

    public StdData(int code, String message, T data, boolean success) {
        this.code = code;
        this.message = message;
        this.data = data;
        this.success = success;
    }

    public static StdData<?> ok() {
        return OK;
    }

    public static <T> StdData<T> of(boolean success) {
        return new StdData<>(success);
    }

    public static <T> StdData<T> ofSuccess(T data) {
        StdData<T> stdData = new StdData<>(200, "success", true);
        stdData.setData(data);
        return stdData;
    }

    public static <T> StdData<T> ofFail(int code, String message) {
        return new StdData<>(code, message, false);
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public String toString() {
        return "StdData{" +
                "code=" + code +
                ", message='" + message + '\'' +
                ", data=" + data +
                ", success=" + success +
                '}';
    }
}
