package com.digiwin.dap.middleware.iam.util;

import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.commons.crypto.constant.KeyConstant;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

/**
 * @author zhuzcz
 * 建议使用com.digiwin.dap.middleware.util.SecureUtils
 */
@Deprecated
public class RSAUtils {

    /**
     * RSA加密公钥
     */
    @Deprecated
    public static final String PUBLIC_KEY = KeyConstant.BASE64_PUBLIC_KEY;

    /**
     * RSA加密私钥
     */
    @Deprecated
    public static final String PRIVATE_KEY = KeyConstant.BASE64_PRIVATE_KEY;

    /**
     * 加密算法RSA
     */
    public static final String KEY_ALGORITHM = "RSA";

    /**
     * RSA最大加密明文大小
     */
    private static final int MAX_ENCRYPT_BLOCK = 245;

    /**
     * RSA最大解密密文大小
     */
    private static final int MAX_DECRYPT_BLOCK = 256;

    /**
     * RSA 位数 如果采用2048 上面最大加密和最大解密则须填写:  245 256
     */
    private static final int INITIALIZE_LENGTH = 2048;

    /**
     * <P>
     * 私钥解密
     * </p>
     *
     * @param encryptedData 已加密数据
     * @param privateKey    私钥(BASE64编码)
     * @return 解密信息
     * @throws Exception 异常
     * @deprecated {@link RSA#decrypt(String, String)}
     */
    public static byte[] decryptByPrivateKey(byte[] encryptedData, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        Key privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(Cipher.DECRYPT_MODE, privateK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        byte[] cache;
        int i = 0;
        // 对数据分段解密
        while (inputLen - offSet > 0) {
            if (inputLen - offSet > MAX_DECRYPT_BLOCK) {
                cache = cipher.doFinal(encryptedData, offSet, MAX_DECRYPT_BLOCK);
            } else {
                cache = cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            }
            out.write(cache, 0, cache.length);
            i++;
            offSet = i * MAX_DECRYPT_BLOCK;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    /**
     * <p>
     * 公钥加密
     * </p>
     *
     * @param data      源数据
     * @param publicKey 公钥(BASE64编码)
     * @return 密文
     * @throws Exception 异常
     * @deprecated {@link RSA#encrypt(String, String)}
     */
    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64(publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        Key publicK = keyFactory.generatePublic(x509KeySpec);
        // 对数据加密
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(Cipher.ENCRYPT_MODE, publicK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        byte[] cache;
        int i = 0;
        // 对数据分段加密
        while (inputLen - offSet > 0) {
            if (inputLen - offSet > MAX_ENCRYPT_BLOCK) {
                cache = cipher.doFinal(data, offSet, MAX_ENCRYPT_BLOCK);
            } else {
                cache = cipher.doFinal(data, offSet, inputLen - offSet);
            }
            out.write(cache, 0, cache.length);
            i++;
            offSet = i * MAX_ENCRYPT_BLOCK;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    /**
     * @param data 加密数据
     * @return 加密结构
     * @throws Exception 异常
     * @deprecated {@link RSA#encrypt(String, String)}
     */
    public static String encryptByPublicKey(String data) throws Exception {
        return encryptByPublicKey(data, PUBLIC_KEY);
    }

    /**
     * @param data            加密数据
     * @param clientPublicKey 密钥
     * @return 加密结构
     * @throws Exception 异常
     * @deprecated {@link RSA#encrypt(String, String)}
     */
    public static String encryptByPublicKey(String data, String clientPublicKey) throws Exception {
        data = Base64.encodeBase64String(encryptByPublicKey(data.getBytes(), clientPublicKey));
        return data;
    }

    /**
     * @param data 被解密数据
     * @return 解密结果
     * @throws Exception 异常
     * @deprecated {@link RSA#decrypt(String, String)}
     */
    public static String decryptByPrivateKey(String data) throws Exception {
        byte[] rs = Base64.decodeBase64(data);
        String temp = new String(RSAUtils.decryptByPrivateKey(rs, PRIVATE_KEY), StandardCharsets.UTF_8);
        return temp;
    }

    /**
     * 获取密码
     *
     * @param passwordHash           客户端公钥加密的密码
     * @param clientEncryptPublicKey 服务端公钥加密的客户端公用
     * @return 密码
     * @deprecated {@link PwdUtils#getPassWord(String, String)}
     */
    public static String getPassWord(String passwordHash, String clientEncryptPublicKey) {
        try {
            String clientPublicKey = RSAUtils.decryptByPrivateKey(clientEncryptPublicKey);
            return AESUtils.aesDecryptString(passwordHash, clientPublicKey);
        } catch (Exception e) {
            throw new RuntimeException("密码错误");
        }
    }

    public static String getDecryptPassword(String passwordHash, String clientEncryptPublicKey) {
        try {
            String clientPublicKey = RSAUtils.decryptByPrivateKey(clientEncryptPublicKey);
            String aesKey = AESUtils.getAesKey(clientPublicKey);
            return AESUtils.aesDecrypt(passwordHash, aesKey);
        } catch (Exception e) {
            throw new RuntimeException("密码错误");
        }
    }
}
