/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.console.api;

import com.digiwin.dap.middle.console.config.ConsoleRedis;
import com.digiwin.dap.middle.console.config.ConsoleRedisProperties;
import com.digiwin.dap.middle.console.domain.RedisEntity;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.util.SecureUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/console/v2/redis"})
public class ConsoleRedisController {
    private static final String PERMISSION_SYS_PREFIX = "iam:permission:sys:";
    @Autowired
    private ConsoleRedisProperties redisProperties;
    @Autowired
    private RedisTemplate<String, Object> dapRedisTemplate;

    @PostMapping(value={"/execute"})
    public ResponseEntity<?> execute(@RequestBody RedisEntity body) {
        body.setKey(SecureUtils.aesDecrypt((String)body.getKey()));
        List<Object> results = new ArrayList();
        if ("search".equals(body.getType())) {
            if (body.getKey() == null || body.getKey().replace("*", "").isEmpty()) {
                RedisConnectionFactory connectionFactory = this.dapRedisTemplate.getConnectionFactory();
                if (!Objects.isNull(connectionFactory)) {
                    Long dbSize = connectionFactory.getConnection().dbSize();
                    results.add(new RedisEntity(body.getKey(), 0L, String.format("\u5f53\u524d\u6570\u636e\u5e93\u7684key\u7684\u6570\u91cf\uff1a%s", dbSize)));
                }
            } else {
                results = this.getRedisValues(body.getKey());
            }
        } else if ("total".equals(body.getType())) {
            Set keys = this.dapRedisTemplate.keys((Object)body.getKey());
            body.setTtl(0L);
            body.setValue(String.format("key\u7684\u6570\u91cf\uff1a%s", keys == null ? 0 : keys.size()));
            results.add(body);
        } else if ("add".equals(body.getType())) {
            if (body.getTtl() == null || body.getTtl() < 1L) {
                this.dapRedisTemplate.opsForValue().set((Object)body.getKey(), body.getValue());
            } else {
                this.dapRedisTemplate.opsForValue().set((Object)body.getKey(), body.getValue(), Duration.ofSeconds(body.getTtl()));
            }
            RedisEntity entity = this.getRedisValue(body.getKey());
            results.add(entity);
        } else if ("del".equals(body.getType())) {
            Boolean delete = this.dapRedisTemplate.delete((Object)body.getKey());
            body.setTtl(0L);
            body.setValue(String.format("\u6210\u529f\u5220\u9664\u6570\u636e\uff1a%s\u6761", Boolean.TRUE.equals(delete) ? 1 : 0));
            results.add(body);
        } else if ("ttl".equals(body.getType())) {
            this.dapRedisTemplate.expire((Object)body.getKey(), body.getTtl().longValue(), TimeUnit.SECONDS);
            RedisEntity entity = this.getRedisValue(body.getKey());
            results.add(entity);
        } else if ("get".equals(body.getType())) {
            RedisEntity entity = this.getRedisValue(body.getKey());
            results.add(entity);
        } else if ("keys".equals(body.getType())) {
            Set keys = this.dapRedisTemplate.keys((Object)body.getKey());
            body.setValue(keys);
            results.add(body);
        }
        return ResponseEntity.ok(results);
    }

    private List<RedisEntity> getRedisValues(String pattern) {
        Set keys = this.dapRedisTemplate.keys((Object)pattern);
        ArrayList<RedisEntity> values = new ArrayList<RedisEntity>();
        if (keys == null || keys.isEmpty()) {
            values.add(new RedisEntity(pattern, 0L, "\u5f53\u524dkey\u6ca1\u7528\u5339\u914d\u5230\u5185\u5bb9"));
        } else {
            int count = 0;
            for (String key : keys) {
                if (count < 100) {
                    ++count;
                    values.add(this.getRedisValue(key));
                    continue;
                }
                values.add(new RedisEntity(key));
            }
        }
        return values;
    }

    private RedisEntity getRedisValue(String key) {
        RedisEntity redisEntity = new RedisEntity();
        redisEntity.setKey(key);
        redisEntity.setTtl(this.dapRedisTemplate.getExpire((Object)key));
        try {
            if (key.startsWith(PERMISSION_SYS_PREFIX)) {
                Set objects = RedisUtils.opsForSet().members((Object)key);
                redisEntity.setValue(objects);
            } else {
                Object value = this.dapRedisTemplate.opsForValue().get((Object)key);
                redisEntity.setValue(value);
            }
        }
        catch (Exception ignored) {
            try {
                Object value = ConsoleRedis.get(this.redisProperties).opsForValue().get((Object)key);
                redisEntity.setValue(value);
            }
            catch (Exception e) {
                redisEntity.setValue("\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
            }
        }
        return redisEntity;
    }
}

