/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.console.api;

import com.digiwin.dap.middle.console.domain.MariadbEntity;
import com.digiwin.dap.middleware.commons.crypto.AES;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/console/v2/mariadb"})
public class ConsoleMariadbController {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @PostMapping(value={"/execute"})
    public ResponseEntity<?> execute(@RequestBody MariadbEntity body) {
        if (StringUtils.isEmpty((CharSequence)body.getExecute())) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        ArrayList<MariadbEntity> results = new ArrayList<MariadbEntity>();
        List<String> executes = body.getSingle() != false ? Collections.singletonList(AES.decrypt((String)body.getExecute(), (String)"Cyrus Smith_____")) : Arrays.asList(AES.decrypt((String)body.getExecute(), (String)"Cyrus Smith_____").split(";"));
        for (String execute : executes) {
            long start = System.nanoTime();
            try {
                Object object;
                MariadbEntity mariadbEntity = new MariadbEntity();
                String sql = StringUtils.stripToEmpty((String)execute);
                String sqlLowerCase = sql.toLowerCase();
                if (sqlLowerCase.contains("insert ") || sqlLowerCase.contains("delete ") || sqlLowerCase.contains("update ")) {
                    object = this.jdbcTemplate.update(sql);
                } else if (sqlLowerCase.contains("select ") || sqlLowerCase.contains("show ") || sqlLowerCase.contains("desc ") || sqlLowerCase.contains("explain ")) {
                    object = this.jdbcTemplate.queryForList(sql);
                } else if (sqlLowerCase.contains("call ")) {
                    Map call = this.jdbcTemplate.call(con -> con.prepareCall(sql), Collections.emptyList());
                    object = call.get("#result-set-1");
                } else {
                    if ("".equals(sql)) continue;
                    this.jdbcTemplate.execute(sql);
                    object = null;
                }
                mariadbEntity.setSuccess(true);
                mariadbEntity.setSql(sql);
                mariadbEntity.setSecond((double)(System.nanoTime() - start) / 1.0E9);
                mariadbEntity.setResult(object);
                results.add(mariadbEntity);
            }
            catch (Exception e) {
                MariadbEntity mariadbEntity = new MariadbEntity();
                mariadbEntity.setSuccess(false);
                mariadbEntity.setSql(execute);
                mariadbEntity.setSecond((double)(System.nanoTime() - start) / 1.0E9);
                mariadbEntity.setResult(e.getMessage());
                results.add(mariadbEntity);
            }
        }
        return ResponseEntity.ok(results);
    }
}

