/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.console.config;

import com.digiwin.dap.middle.console.config.ConsoleRedisProperties;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

public class ConsoleRedis {
    private static volatile RedisTemplate<String, Object> template;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisTemplate<String, Object> get(ConsoleRedisProperties env) {
        if (template != null) return template;
        Class<ConsoleRedis> clazz = ConsoleRedis.class;
        synchronized (ConsoleRedis.class) {
            if (template != null) return template;
            RedisTemplate temp = new RedisTemplate();
            temp.setConnectionFactory((RedisConnectionFactory)ConsoleRedis.createJedisConnectionFactory(env));
            temp.setKeySerializer(RedisSerializer.string());
            temp.setValueSerializer(RedisSerializer.java());
            temp.afterPropertiesSet();
            template = temp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return template;
        }
    }

    private static JedisConnectionFactory createJedisConnectionFactory(ConsoleRedisProperties env) {
        JedisClientConfiguration clientConfiguration = ConsoleRedis.getJedisClientConfiguration();
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(ConsoleRedis.getStandaloneConfig(env), clientConfiguration);
        jedisConnectionFactory.afterPropertiesSet();
        return jedisConnectionFactory;
    }

    private static JedisClientConfiguration getJedisClientConfiguration() {
        JedisClientConfiguration.JedisClientConfigurationBuilder builder = ConsoleRedis.applyProperties(JedisClientConfiguration.builder());
        builder.usePooling().poolConfig((GenericObjectPoolConfig)ConsoleRedis.jedisPoolConfig());
        return builder.build();
    }

    private static RedisStandaloneConfiguration getStandaloneConfig(ConsoleRedisProperties env) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(env.getRedisHost());
        config.setPort(env.getRedisPort().intValue());
        config.setPassword(RedisPassword.of((String)env.getRedisPassword()));
        config.setDatabase(env.getRedisDb().intValue());
        return config;
    }

    private static JedisClientConfiguration.JedisClientConfigurationBuilder applyProperties(JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        Duration timeout = Duration.ofSeconds(4L);
        builder.readTimeout(timeout).connectTimeout(timeout);
        return builder;
    }

    private static JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(1);
        config.setMaxIdle(1);
        config.setMinIdle(1);
        config.setMaxWait(Duration.ofSeconds(5L));
        return config;
    }
}

