package com.digiwin.dap.middle.console.domain.admin;

import java.util.*;
import java.util.stream.Collectors;

public class SqlRule {

    private final Map<String, SqlTableRule> tables = new HashMap<>();
    private final Set<String> functions = new HashSet<>();
    private final Set<String> withs = new HashSet<>();

    public SqlRule() {
    }

    public SqlRule table(String table, String... cols) {
        String tableLowerCase = table.toLowerCase();
        if (this.tables.containsKey(tableLowerCase)) {
            this.tables.get(tableLowerCase).columns(cols);
        } else {
            SqlTableRule SQLTableRule = new SqlTableRule();
            SQLTableRule.columns(cols);
            this.tables.put(tableLowerCase, SQLTableRule);
        }
        return this;
    }

    public SqlRule functions(String... funs) {
        this.functions.addAll(Arrays.stream(funs).map(String::toUpperCase).collect(Collectors.toList()));
        return this;
    }

    public SqlRule with(String with) {
        this.withs.add(with);
        return this;
    }

    public boolean containsTable(String table) {
        return tables.containsKey(table.toLowerCase());
    }

    public boolean containsColumn(String table, String column) {
        return tables.get(table.toLowerCase()).getColumns().contains(column.toLowerCase());
    }

    public boolean containsFunction(String function) {
        return functions.contains(function.toUpperCase());
    }

    public boolean containsWith(String with) {
        return withs.contains(with.toLowerCase());
    }

    @Override
    public String toString() {
        return "共 " + tables.size() + " 张表，" + functions.size() + " 个函数。";
    }
}
