/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.aspect;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.service.CascadeDeleteEntityService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.persistence.Table;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CascadeDeleteEntityRepository {
    @Autowired
    private CascadeDeleteEntityService cascadeDeleteEntityService;

    @Pointcut(value="execution(public void org.springframework.data.repository.Repository+.deleteById(..))")
    public void deleteByIdPoint() {
    }

    @Pointcut(value="execution(public void org.springframework.data.repository.Repository+.delete(..))")
    public void deletePoint() {
    }

    @Pointcut(value="execution(public void org.springframework.data.repository.Repository+.deleteAll(..))")
    public void deleteAllPoint() {
    }

    @Pointcut(value="execution(public void org.springframework.data.repository.Repository+.deleteInBatch(..))")
    public void deleteInBatchPoint() {
    }

    @Before(value="deleteInBatchPoint()")
    public void cascadeDeleteByBatch(JoinPoint pjp) {
        this.deleteInBatch(pjp);
    }

    @Before(value="deleteAllPoint()")
    public void cascadeDeleteByAll(JoinPoint pjp) {
        this.deleteInBatch(pjp);
    }

    private void deleteInBatch(JoinPoint pjp) {
        if (pjp.getArgs().length > 0 && pjp.getArgs()[0] instanceof Iterable) {
            String name = this.getTableName(pjp);
            Iterable entities = (Iterable)pjp.getArgs()[0];
            ArrayList<Long> sids = new ArrayList<Long>();
            for (BaseEntity BaseEntity2 : entities) {
                sids.add(BaseEntity2.getSid());
            }
            this.cascadeDeleteEntityService.delete(name, sids);
        }
    }

    @Before(value="deleteByIdPoint()")
    public void cascadeDeleteById(JoinPoint pjp) {
        if (pjp.getArgs()[0] instanceof Long) {
            String name = this.getTableName(pjp);
            Long id = (Long)pjp.getArgs()[0];
            ArrayList<Long> sids = new ArrayList<Long>();
            sids.add(id);
            this.cascadeDeleteEntityService.delete(name, sids);
        }
    }

    @Before(value="deletePoint()")
    public void cascadeDelete(JoinPoint pjp) {
        if (pjp.getArgs()[0] instanceof BaseEntity) {
            String name = this.getTableName(pjp);
            BaseEntity entity = (BaseEntity)pjp.getArgs()[0];
            ArrayList<Long> sids = new ArrayList<Long>();
            sids.add(entity.getSid());
            this.cascadeDeleteEntityService.delete(name, sids);
        }
    }

    private String getTableName(JoinPoint pjp) {
        Type genType = pjp.getTarget().getClass().getInterfaces()[0].getGenericInterfaces()[0];
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        Table annotation = ((Class)params[0]).getAnnotation(Table.class);
        String name = annotation == null ? ((Class)params[0]).getSimpleName().toLowerCase() : annotation.name();
        return name;
    }
}

