/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.converter;

import com.digiwin.dap.middleware.converter.BaseEnAndDecryptConverter;
import com.digiwin.dap.middleware.domain.SafeStorageValue;
import com.digiwin.dap.middleware.util.SecureUtils;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(autoApply=true)
public class AutoEnAndDecryptConverter
extends BaseEnAndDecryptConverter<SafeStorageValue> {
    private static final Logger logger = LoggerFactory.getLogger(AutoEnAndDecryptConverter.class);

    @Nullable
    public String convertToDatabaseColumn(SafeStorageValue attribute) {
        Function toStringFunc;
        if (attribute == null) {
            return null;
        }
        Object value = attribute.get();
        if (value == null) {
            return null;
        }
        String toEncrypt = null;
        toEncrypt = value instanceof String ? (String)value : ((toStringFunc = attribute.getToStringFunc()) == null ? value.toString() : (String)toStringFunc.apply(value));
        try {
            return SecureUtils.aesEncrypt((String)toEncrypt);
        }
        catch (Exception e) {
            logger.error("\u3010SecureUtils.aesEncrypt\u3011{}", (Object)e.getMessage());
            return toEncrypt;
        }
    }

    @Nonnull
    public SafeStorageValue convertToEntityAttribute(String dbData) {
        if (dbData == null) {
            return new SafeStorageValue(null);
        }
        String aesDecrypt = null;
        try {
            aesDecrypt = SecureUtils.aesDecrypt((String)dbData);
        }
        catch (Exception e) {
            logger.error("\u3010SecureUtils.aesDecrypt\u3011{}", (Object)e.getMessage());
            return new SafeStorageValue((Object)dbData);
        }
        return new SafeStorageValue((Object)aesDecrypt);
    }
}

