package com.digiwin.dap.middleware.util;

import com.digiwin.dap.middleware.entity.BaseEntity;

import java.time.LocalDateTime;

/**
 * 基础字段维护
 *
 * @author fobgochod
 * @since 2.7.20
 */
public class EntityUtils {

    /**
     * 新增数据，给基础字段赋值
     *
     * @param entity entity
     */
    public static void setCreateFields(BaseEntity entity) {
        // 为空则设置创建字段值
        if (entity.getCreateBy() == null || entity.getCreateBy() == 0) {
            entity.setCreateBy(UserUtils.getUserSid());
        }
        if (entity.getCreateById() == null || "".equals(entity.getCreateById())) {
            entity.setCreateById(UserUtils.getUserName());
        }
        if (entity.getCreateDate() == null) {
            entity.setCreateDate(LocalDateTime.now());
        }
        entity.setCreateProvider(UserUtils.getSysSid());
        entity.setCreateOrg(0L);
        // 设置修改字段值
        setModifyFields(entity);
    }

    /**
     * 修改数据，给基础字段赋值
     *
     * @param entity entity
     */
    public static void setModifyFields(BaseEntity entity) {
        // 设置修改字段值
        entity.setModifyBy(UserUtils.getUserSid());
        entity.setModifyById(UserUtils.getUserName());
        entity.setModifyDate(LocalDateTime.now());
        entity.setModifyProvider(UserUtils.getSysSid());
    }
}
