package com.digiwin.dap.middleware.entity;

import java.util.Objects;

/**
 * 级联删除子表信息
 *
 * @author fobgochod
 * @date 2021/1/12
 */
public class AssociationEntity {

    private String tableName;
    private String fieldName;
    private boolean isCascadeDelete;

    public AssociationEntity() {
    }

    public AssociationEntity(String tableName, String fieldName, boolean isCascadeDelete) {
        this.tableName = tableName;
        this.fieldName = fieldName;
        this.isCascadeDelete = isCascadeDelete;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }


    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isCascadeDelete() {
        return isCascadeDelete;
    }

    public void setCascadeDelete(boolean cascadeDelete) {
        isCascadeDelete = cascadeDelete;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AssociationEntity that = (AssociationEntity) o;
        return tableName.equals(that.tableName) && fieldName.equals(that.fieldName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tableName, fieldName);
    }
}
