package com.digiwin.dap.middleware.entity;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 分区表基类
 *
 * @author fobgochod
 * @date 2022/12/2 10:07
 */
@MappedSuperclass
public abstract class BaseEntityWithPartition extends BaseEntity {

    /**
     * 分区主键 => 租户sid
     */
    @Column(name = "tenant_sid", nullable = false)
    private long tenantSid;

    public long getTenantSid() {
        return tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }
}
