/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.aspect;

import com.digiwin.dap.middle.database.encrypt.annotation.Desensitization;
import com.digiwin.dap.middle.database.encrypt.config.DatabaseEncryptConfig;
import com.digiwin.dap.middle.database.encrypt.desensitization.context.DesensitizationConvertContext;
import com.digiwin.dap.middle.database.encrypt.desensitization.service.DesensitizationConverter;
import com.digiwin.dap.middle.database.encrypt.model.ObjectRelationalMapping;
import com.digiwin.dap.middle.database.encrypt.utils.CamelToSnakeUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Table;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnBean(value={DatabaseEncryptConfig.class})
public class EncryptionAndDecryptionAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionAndDecryptionAspect.class);
    private static final String QUERY_PATTERN = "find|read|get|query|search|stream";
    private static final String COUNT_PATTERN = "count";
    private static final String EXISTS_PATTERN = "exists";
    private static final String DELETE_PATTERN = "delete|remove";
    private static final Pattern PREFIX_TEMPLATE = Pattern.compile("^(find|read|get|query|search|stream|count|exists|delete|remove)((\\p{Lu}.*?))??By");
    @Autowired
    private DesensitizationConverter<Object> desensitizationConverter;

    @Pointcut(value="execution(* com.digiwin.dap.middleware.*.repository..*.*(..)) ||execution(* org.springframework.data.jpa.repository.JpaRepository.*(..)) || execution(* com.digiwin.dap.middleware.repository.BaseEntityWithIdRepository.*(..)) || execution(* com.digiwin.dap.middleware.repository.BaseEntityRepository.*(..))")
    public void repositoryMethods() {
    }

    @Around(value="repositoryMethods()")
    public Object beforeRepositoryMethodExecution(ProceedingJoinPoint joinPoint) throws Throwable {
        List<ObjectRelationalMapping> mappings;
        TargetMethodInfo targetMethodInfo;
        Object[] args = joinPoint.getArgs();
        try {
            targetMethodInfo = this.getTargetMethodInfo(joinPoint);
            mappings = this.buildObjectRelationalMapping(targetMethodInfo.getEntityClass());
        }
        catch (Exception e) {
            LOGGER.error("===>JPA\u89e3\u6790\u65b9\u6cd5\u5f02\u5e38");
            return joinPoint.proceed();
        }
        if (Objects.isNull(targetMethodInfo.getEntityClass()) || Objects.isNull(targetMethodInfo.getMethod())) {
            return joinPoint.proceed();
        }
        if (!(targetMethodInfo.getEntityClass().isAnnotationPresent(Table.class) && targetMethodInfo.getEntityClass().isAnnotationPresent(Desensitization.class) && targetMethodInfo.getEntityClass().getAnnotation(Desensitization.class).enabled())) {
            return joinPoint.proceed();
        }
        if (targetMethodInfo.getMethod().isAnnotationPresent(Query.class)) {
            return joinPoint.proceed();
        }
        String targetMethod = targetMethodInfo.getInterfaceClass().getName() + "." + targetMethodInfo.getMethod().getName();
        try {
            List<String> conditionList = this.parserMethodName(targetMethodInfo.getEntityClass(), joinPoint.getSignature().getName(), args);
            for (int i = 0; i < args.length; ++i) {
                String fieldName = conditionList.size() > i ? conditionList.get(i) : "";
                List<Object> paramMappings = StrUtils.isNotEmpty((String)fieldName) ? mappings.stream().filter(x -> x.getObjectPropertyName().equals(fieldName)).collect(Collectors.toList()) : mappings;
                DesensitizationConvertContext parameterContext = new DesensitizationConvertContext(targetMethod, paramMappings);
                parameterContext.setContext(args[i]);
                args[i] = this.desensitizationConverter.desensitize(parameterContext);
            }
        }
        catch (Exception e) {
            LOGGER.error("===>{}\u52a0\u5bc6\u53c2\u6570\u5f02\u5e38", (Object)targetMethod, (Object)e);
        }
        Object result = joinPoint.proceed(args);
        if (Objects.nonNull(result) && result instanceof HibernateProxy) {
            LOGGER.warn("===>{}\u542f\u7528\u4e86Hibernate\u5ef6\u8fdf\u52a0\u8f7d\u4e0d\u652f\u6301\u52a0\u89e3\u5bc6", (Object)targetMethod);
            return result;
        }
        try {
            DesensitizationConvertContext resultContext = new DesensitizationConvertContext(targetMethod, mappings);
            resultContext.setContext(this.cloneResult(result));
            Optional<Object> newObject = this.desensitizationConverter.revert(resultContext);
            return result instanceof Optional ? Optional.ofNullable(newObject) : newObject;
        }
        catch (Exception e) {
            LOGGER.error("===>{}\u7ed3\u679c\u89e3\u5bc6\u5931\u8d25", (Object)targetMethod, (Object)e);
            return result;
        }
    }

    private List<ObjectRelationalMapping> buildObjectRelationalMapping(Class<?> entityClass) {
        ArrayList<ObjectRelationalMapping> objectRelationalMappings = new ArrayList<ObjectRelationalMapping>();
        Table table = entityClass.getAnnotation(Table.class);
        for (Field field : entityClass.getDeclaredFields()) {
            String objectPropertyName = field.getName();
            Column column = field.getAnnotation(Column.class);
            String dataBaseColumnName = column != null && StrUtils.isNotEmpty((String)column.name()) ? column.name() : CamelToSnakeUtils.convertCamelToSnake((String)objectPropertyName);
            objectRelationalMappings.add(new ObjectRelationalMapping(table.name(), dataBaseColumnName, objectPropertyName));
        }
        return objectRelationalMappings;
    }

    private Object cloneResult(Object result) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        if (result instanceof Optional) {
            out.writeObject(((Optional)result).orElse(null));
        } else {
            out.writeObject(result);
        }
        out.flush();
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        return in.readObject();
    }

    private List<String> parserMethodName(Class<?> entityClass, String methodName, Object[] args) {
        Matcher matcher;
        ArrayList<String> conditionFieldList = new ArrayList<String>();
        if (Objects.nonNull(args) && args.length > 0 && (matcher = PREFIX_TEMPLATE.matcher(methodName)).find()) {
            PartTree tree = new PartTree(methodName, entityClass);
            for (Part part : tree.getParts()) {
                String property = part.getProperty().toDotPath();
                conditionFieldList.add(property);
            }
        }
        return conditionFieldList;
    }

    private TargetMethodInfo getTargetMethodInfo(ProceedingJoinPoint joinPoint) {
        String methodName = joinPoint.getSignature().getName();
        Class<?> targetClass = joinPoint.getTarget().getClass();
        Class<?> interfaceClass = targetClass.getInterfaces()[0];
        Type[] type = interfaceClass.getGenericInterfaces();
        Type genericInterface = type[0];
        Class entityClass = null;
        if (genericInterface instanceof ParameterizedType) {
            Type[] typeArgs = ((ParameterizedType)genericInterface).getActualTypeArguments();
            entityClass = typeArgs.length > 0 ? (Class)typeArgs[0] : null;
        }
        Optional<Method> optionalMethod = Arrays.stream(interfaceClass.getMethods()).filter(method -> method.getName().equals(methodName)).findFirst();
        return new TargetMethodInfo(interfaceClass, optionalMethod.orElse(null), entityClass);
    }

    static class TargetMethodInfo {
        private final Class<?> interfaceClass;
        private final Method method;
        private final Class<?> entityClass;

        TargetMethodInfo(Class<?> interfaceClass, Method method, Class<?> entityClass) {
            this.interfaceClass = interfaceClass;
            this.method = method;
            this.entityClass = entityClass;
        }

        public Class<?> getInterfaceClass() {
            return this.interfaceClass;
        }

        public Method getMethod() {
            return this.method;
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }
    }
}

