/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.util;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static Pattern regex = Pattern.compile("[A-Z]+");
    private final String driver = "com.mysql.jdbc.Driver";
    Connection connection;
    private String username;
    private String password;
    private String url;
    private Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils(String url, String user, String password) {
        this.url = url;
        this.username = user;
        this.password = password;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            System.out.println("\u6ce8\u518c\u9a71\u52a8\u6210\u529f\uff01\uff01");
        }
        catch (ClassNotFoundException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            System.out.println("\u6ce8\u518c\u9a71\u52a8\u5931\u8d25\uff01\uff01");
        }
    }

    public static JdbcUtils create(String url, String user, String password) {
        return new JdbcUtils(url, user, password);
    }

    private Connection getConnection() {
        try {
            if (this.connection == null) {
                this.connection = DriverManager.getConnection(this.url, this.username, this.password);
            }
            return this.connection;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            System.out.println("Connection com.digiwin.middleware.core.exception !");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateByPreparedStatement(String sql, List<Object> params) throws SQLException {
        Statement pstmt = null;
        ResultSet resultSet = null;
        try {
            boolean flag;
            int result = -1;
            int index = 1;
            pstmt = this.getConnection().prepareStatement(sql);
            if (params != null && !params.isEmpty()) {
                for (int i = 0; i < params.size(); ++i) {
                    pstmt.setObject(index++, params.get(i));
                }
            }
            boolean bl = flag = (result = pstmt.executeUpdate()) > 0;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T findSimpleRefResult(String sql, List<Object> params, Class<T> cls) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet resultSet = null;
        try {
            int index = 1;
            pstmt = this.getConnection().prepareStatement(sql);
            if (params != null && !params.isEmpty()) {
                for (int i = 0; i < params.size(); ++i) {
                    pstmt.setObject(index++, params.get(i));
                }
            }
            resultSet = pstmt.executeQuery();
            List fieldList = BeanUtils.getDeclaredFields(cls);
            T resultObject = cls.newInstance();
            if (resultSet.next()) {
                this.fillFieldValue(cls, fieldList, resultSet, resultObject);
            }
            T t = resultObject;
            return t;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    private <T> void fillFieldValue(Class<T> cls, List<Field> fieldList, ResultSet resultSet, T resultObject) throws SQLException, IllegalAccessException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        block0: for (Field field : fieldList) {
            String columnName;
            Column column = field.getAnnotation(Column.class);
            if (column == null || StrUtils.isEmpty((String)column.name())) {
                columnName = field.getName();
                Matcher matcher = regex.matcher(columnName);
                if (matcher.find()) {
                    columnName = matcher.replaceAll("_$0");
                }
                columnName = columnName.toUpperCase();
            } else {
                columnName = column.name().toUpperCase();
                if (columnName.startsWith("[")) {
                    columnName = columnName.replace("[", "");
                    columnName = columnName.replace("]", "");
                }
            }
            for (int colIndex = 1; colIndex <= metaData.getColumnCount(); ++colIndex) {
                if (!metaData.getColumnName(colIndex).toUpperCase().equals(columnName) && !metaData.getColumnLabel(colIndex).toUpperCase().equals(columnName)) continue;
                Object colValue = resultSet.getObject(metaData.getColumnLabel(colIndex));
                if (colValue == null) continue block0;
                field.setAccessible(true);
                String datetimeType = "DATETIME";
                if (metaData.getColumnTypeName(colIndex).equals(datetimeType)) {
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S");
                    colValue = LocalDateTime.parse(colValue.toString(), df);
                }
                field.set(resultObject, colValue);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> findMoreRefResult(String sql, List<Object> params, Class<T> cls) throws Exception {
        Statement pstmt = null;
        ResultSet resultSet = null;
        try {
            ArrayList<T> list = new ArrayList<T>();
            int index = 1;
            pstmt = this.getConnection().prepareStatement(sql);
            if (params != null && !params.isEmpty()) {
                for (int i = 0; i < params.size(); ++i) {
                    pstmt.setObject(index++, params.get(i));
                }
            }
            resultSet = pstmt.executeQuery();
            List fieldList = BeanUtils.getDeclaredFields(cls);
            while (resultSet.next()) {
                T resultObject = cls.newInstance();
                this.fillFieldValue(cls, fieldList, resultSet, resultObject);
                list.add(resultObject);
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public void closeConnection() throws SQLException {
        this.connection.close();
    }
}

