/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.service.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.service.EntityWithUnionKeyManagerService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseEntityWithUnionKeyManagerService<T extends BaseEntity>
extends BaseEntityManagerService<T>
implements EntityWithUnionKeyManagerService<T> {
    @PersistenceContext
    EntityManager entityManager;
    private UnionKey unionKey;

    @Override
    public UnionKey getUnionKey() {
        if (this.unionKey == null) {
            this.unionKey = this.createUnionKey();
        }
        return this.unionKey;
    }

    protected abstract UnionKey createUnionKey();

    @Override
    protected abstract BaseEntityRepository getRepository();

    @Override
    public long getSidByUnionKey(Object ... values) {
        String sql = String.format("SELECT SID FROM %s WHERE %s LIMIT 1", this.getMappingTableName(), this.getUnionKey().getWhere(values));
        Query query = this.entityManager.createNativeQuery(sql);
        List<String> fields = this.getUnionKey().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            query.setParameter(fields.get(i), values[i]);
        }
        List resultList = query.getResultList();
        if (resultList.size() == 0) {
            return 0L;
        }
        return Long.parseLong(resultList.get(0).toString());
    }

    @Override
    public T findByUnionKey(final Object ... values) {
        Optional result = this.getRepository().findOne(new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
                return BaseEntityWithUnionKeyManagerService.this.getUnionKey().getSpecification(root, criteriaQuery, criteriaBuilder, values);
            }
        });
        if (result.isPresent()) {
            return (T)((BaseEntity)result.get());
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByUnionKey(Object ... values) {
        String sql = String.format("DELETE FROM %s WHERE %s LIMIT 1", this.getMappingTableName(), this.getUnionKey().getWhere(values));
        Query query = this.entityManager.createNativeQuery(sql);
        List<String> fields = this.getUnionKey().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            query.setParameter(fields.get(i), values[i]);
        }
        query.executeUpdate();
    }

    @Override
    public boolean existsByUnionKey(Object ... values) {
        String sql = String.format("SELECT COUNT(SID) FROM %s WHERE %s LIMIT 1", this.getMappingTableName(), this.getUnionKey().getWhere(values));
        Query query = this.entityManager.createNativeQuery(sql);
        List<String> fields = this.getUnionKey().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            query.setParameter(fields.get(i), values[i]);
        }
        Object result = query.getSingleResult();
        return result != null && Integer.parseInt(result.toString()) > 0;
    }

    @Override
    public void enable(Object ... values) {
        T data = this.findByUnionKey(values);
        if (data == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.union key:" + values);
        }
        ((BaseEntity)data).setDisabled(false);
        this.getRepository().save(data);
    }

    @Override
    public void disable(Object ... values) {
        T data = this.findByUnionKey(values);
        if (data == null) {
            throw new BusinessException("\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664.union key:" + values);
        }
        ((BaseEntity)data).setDisabled(true);
        this.getRepository().save(data);
    }
}

