package com.digiwin.dap.middleware.entity;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotBlank;

/**
 * 所有带Id字段且作为不可重复主键的实体
 *
 * @author fobgochod
 * @date 2020/4/27
 */
@MappedSuperclass
public abstract class BaseEntityWithId extends BaseEntity {

    /**
     * 账号id
     */
    @NotBlank(message = "必填")
    @Column(name = "ID", unique = true, nullable = false, length = 100)
    private String id;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
}
