package com.digiwin.dap.middleware.repository;

import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import org.springframework.data.repository.NoRepositoryBean;

/**
 * Id作为不可重复key的实体的基本DAO，提供基于id的基本操作
 */
@NoRepositoryBean
public interface BaseEntityWithIdRepository<T extends BaseEntityWithId, ID> extends BaseEntityRepository<T, ID> {

    /**
     * 根据Id获取实体
     *
     * @param id 实体ID
     * @return 实体对象
     */
    T findById(String id);

    /**
     * 根据id判断是否存在
     *
     * @param id
     * @return
     */
    boolean existsById(String id);


    /**
     * 根据Id删除实体
     *
     * @param id 实体ID
     * @return
     */
    void deleteById(String id);
}
