package com.digiwin.dap.middle.cache.limiter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <a href="https://en.wikipedia.org/wiki/Token_bucket">Token Bucket Algorithm.</a>
 *
 * @author fobgochod
 * @date 2023/6/6 15:36
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface RateLimiter {

    /**
     * how many requests per second to allow (without any dropped requests).
     * This is the rate at which the token bucket is filled.
     */
    int replenishRate() default 1;

    /**
     * the maximum number of requests a user is allowed in a single second (without any dropped requests).
     * This is the number of tokens the token bucket can hold. Setting this value to zero blocks all requests.
     */
    int burstCapacity() default 1;

    /**
     * how many tokens a request costs.
     * This is the number of tokens taken from the bucket for each request and defaults to 1.
     */
    int requestedTokens() default 1;

    /**
     * 启用用户维度进行控制
     */
    boolean user() default false;

    /**
     * 启用租户维度进行控制
     */
    boolean tenant() default true;

    /**
     * 启用应用维度进行控制
     */
    boolean sys() default false;

    /**
     * 启用ip维度进行控制
     */
    boolean ip() default false;
}
