/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.cache.limiter;

import com.digiwin.dap.middle.cache.limiter.RateLimiter;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.RequestNotPermittedException;
import com.digiwin.dap.middleware.util.NetUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RateLimiterInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterInterceptor.class);
    private final RedisTemplate<String, Object> redisTemplate;
    private final RedisScript<Boolean> script;
    @Value(value="${spring.application.name:dap}")
    private String appName;

    public RateLimiterInterceptor(RedisTemplate<String, Object> redisTemplate, @Qualifier(value="redisRequestRateLimiterScript") RedisScript<Boolean> script) {
        this.redisTemplate = redisTemplate;
        this.script = script;
    }

    @Before(value="(@annotation(com.digiwin.dap.middle.cache.limiter.RateLimiter))")
    public void execute(JoinPoint joinPoint) {
        Boolean allowed = true;
        try {
            RateLimiter rateLimiter = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(RateLimiter.class);
            List<String> keys = RateLimiterInterceptor.getKeys(this.appName, rateLimiter);
            int replenishRate = rateLimiter.replenishRate();
            int burstCapacity = rateLimiter.burstCapacity();
            int requestedTokens = rateLimiter.requestedTokens();
            allowed = (Boolean)this.redisTemplate.execute(this.script, keys, new Object[]{replenishRate, burstCapacity, requestedTokens});
        }
        catch (Exception e) {
            logger.error("Error determining if user allowed from redis", (Throwable)e);
        }
        if (allowed == null || !allowed.booleanValue()) {
            throw new RequestNotPermittedException((ErrorHandler)CommonErrorCode.TOO_MANY_REQUESTS);
        }
    }

    static List<String> getKeys(String appName, RateLimiter rateLimiter) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(attributes).getRequest();
        StringBuilder prefix = new StringBuilder(appName + ":limiter:{" + request.getServletPath() + "}");
        if (rateLimiter.user() && UserUtils.getUserId() != null) {
            prefix.append(":").append(UserUtils.getUserId());
        }
        if (rateLimiter.tenant() && UserUtils.getTenantId() != null) {
            prefix.append(":").append(UserUtils.getTenantId());
        }
        if (rateLimiter.sys() && UserUtils.getSysId() != null) {
            prefix.append(":").append(UserUtils.getSysId());
        }
        if (rateLimiter.ip()) {
            prefix.append(":").append(NetUtils.getClientIP((HttpServletRequest)request));
        }
        String tokenKey = prefix + ".tokens";
        String timestampKey = prefix + ".timestamp";
        return Arrays.asList(tokenKey, timestampKey);
    }
}

